// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluationsRequest
type PutEvaluationsInput struct {
	_ struct{} `type:"structure"`

	// The assessments that the AWS Lambda function performs. Each evaluation identifies
	// an AWS resource and indicates whether it complies with the AWS Config rule
	// that invokes the AWS Lambda function.
	Evaluations []Evaluation `type:"list"`

	// An encrypted token that associates an evaluation with an AWS Config rule.
	// Identifies the rule and the event that triggered the evaluation.
	//
	// ResultToken is a required field
	ResultToken *string `type:"string" required:"true"`

	// Use this parameter to specify a test run for PutEvaluations. You can verify
	// whether your AWS Lambda function will deliver evaluation results to AWS Config.
	// No updates occur to your existing evaluations, and evaluation results are
	// not sent to AWS Config.
	//
	// When TestMode is true, PutEvaluations doesn't require a valid value for the
	// ResultToken parameter, but the value cannot be null.
	TestMode *bool `type:"boolean"`
}

// String returns the string representation
func (s PutEvaluationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEvaluationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEvaluationsInput"}

	if s.ResultToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResultToken"))
	}
	if s.Evaluations != nil {
		for i, v := range s.Evaluations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Evaluations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluationsResponse
type PutEvaluationsOutput struct {
	_ struct{} `type:"structure"`

	// Requests that failed because of a client or server error.
	FailedEvaluations []Evaluation `type:"list"`
}

// String returns the string representation
func (s PutEvaluationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutEvaluations = "PutEvaluations"

// PutEvaluationsRequest returns a request value for making API operation for
// AWS Config.
//
// Used by an AWS Lambda function to deliver evaluation results to AWS Config.
// This action is required in every AWS Lambda function that is invoked by an
// AWS Config rule.
//
//    // Example sending a request using PutEvaluationsRequest.
//    req := client.PutEvaluationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations
func (c *Client) PutEvaluationsRequest(input *PutEvaluationsInput) PutEvaluationsRequest {
	op := &aws.Operation{
		Name:       opPutEvaluations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEvaluationsInput{}
	}

	req := c.newRequest(op, input, &PutEvaluationsOutput{})
	return PutEvaluationsRequest{Request: req, Input: input, Copy: c.PutEvaluationsRequest}
}

// PutEvaluationsRequest is the request type for the
// PutEvaluations API operation.
type PutEvaluationsRequest struct {
	*aws.Request
	Input *PutEvaluationsInput
	Copy  func(*PutEvaluationsInput) PutEvaluationsRequest
}

// Send marshals and sends the PutEvaluations API request.
func (r PutEvaluationsRequest) Send(ctx context.Context) (*PutEvaluationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEvaluationsResponse{
		PutEvaluationsOutput: r.Request.Data.(*PutEvaluationsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEvaluationsResponse is the response type for the
// PutEvaluations API operation.
type PutEvaluationsResponse struct {
	*PutEvaluationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEvaluations request.
func (r *PutEvaluationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
