// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilesRequest
type ListSecurityProfilesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of security profiles to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSecurityProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityProfilesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSecurityProfilesInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSecurityProfilesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilesResponse
type ListSecurityProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	NextToken *string `type:"string"`

	// An array of SecurityProfileSummary objects.
	SecurityProfileSummaryList []SecurityProfileSummary `type:"list"`
}

// String returns the string representation
func (s ListSecurityProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSecurityProfilesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SecurityProfileSummaryList) > 0 {
		v := s.SecurityProfileSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityProfileSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListSecurityProfiles = "ListSecurityProfiles"

// ListSecurityProfilesRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Returns an array of SecurityProfileSummary objects that contain information
// about the security profiles in your instance, including the ARN, Id, and
// Name of the security profile.
//
//    // Example sending a request using ListSecurityProfilesRequest.
//    req := client.ListSecurityProfilesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles
func (c *Client) ListSecurityProfilesRequest(input *ListSecurityProfilesInput) ListSecurityProfilesRequest {
	op := &aws.Operation{
		Name:       opListSecurityProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-summary/{InstanceId}",
	}

	if input == nil {
		input = &ListSecurityProfilesInput{}
	}

	req := c.newRequest(op, input, &ListSecurityProfilesOutput{})
	return ListSecurityProfilesRequest{Request: req, Input: input, Copy: c.ListSecurityProfilesRequest}
}

// ListSecurityProfilesRequest is the request type for the
// ListSecurityProfiles API operation.
type ListSecurityProfilesRequest struct {
	*aws.Request
	Input *ListSecurityProfilesInput
	Copy  func(*ListSecurityProfilesInput) ListSecurityProfilesRequest
}

// Send marshals and sends the ListSecurityProfiles API request.
func (r ListSecurityProfilesRequest) Send(ctx context.Context) (*ListSecurityProfilesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSecurityProfilesResponse{
		ListSecurityProfilesOutput: r.Request.Data.(*ListSecurityProfilesOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListSecurityProfilesResponse is the response type for the
// ListSecurityProfiles API operation.
type ListSecurityProfilesResponse struct {
	*ListSecurityProfilesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSecurityProfiles request.
func (r *ListSecurityProfilesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
