// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datapipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for SetTaskStatus.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetTaskStatusInput
type SetTaskStatusInput struct {
	_ struct{} `type:"structure"`

	// If an error occurred during the task, this value specifies the error code.
	// This value is set on the physical attempt object. It is used to display error
	// information to the user. It should not start with string "Service_" which
	// is reserved by the system.
	ErrorId *string `locationName:"errorId" type:"string"`

	// If an error occurred during the task, this value specifies a text description
	// of the error. This value is set on the physical attempt object. It is used
	// to display error information to the user. The web service does not parse
	// this value.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// If an error occurred during the task, this value specifies the stack trace
	// associated with the error. This value is set on the physical attempt object.
	// It is used to display error information to the user. The web service does
	// not parse this value.
	ErrorStackTrace *string `locationName:"errorStackTrace" type:"string"`

	// The ID of the task assigned to the task runner. This value is provided in
	// the response for PollForTask.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" min:"1" type:"string" required:"true"`

	// If FINISHED, the task successfully completed. If FAILED, the task ended unsuccessfully.
	// Preconditions use false.
	//
	// TaskStatus is a required field
	TaskStatus TaskStatus `locationName:"taskStatus" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SetTaskStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTaskStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetTaskStatusInput"}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 1))
	}
	if len(s.TaskStatus) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TaskStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of SetTaskStatus.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetTaskStatusOutput
type SetTaskStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTaskStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetTaskStatus = "SetTaskStatus"

// SetTaskStatusRequest returns a request value for making API operation for
// AWS Data Pipeline.
//
// Task runners call SetTaskStatus to notify AWS Data Pipeline that a task is
// completed and provide information about the final status. A task runner makes
// this call regardless of whether the task was sucessful. A task runner does
// not need to call SetTaskStatus for tasks that are canceled by the web service
// during a call to ReportTaskProgress.
//
//    // Example sending a request using SetTaskStatusRequest.
//    req := client.SetTaskStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetTaskStatus
func (c *Client) SetTaskStatusRequest(input *SetTaskStatusInput) SetTaskStatusRequest {
	op := &aws.Operation{
		Name:       opSetTaskStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTaskStatusInput{}
	}

	req := c.newRequest(op, input, &SetTaskStatusOutput{})
	return SetTaskStatusRequest{Request: req, Input: input, Copy: c.SetTaskStatusRequest}
}

// SetTaskStatusRequest is the request type for the
// SetTaskStatus API operation.
type SetTaskStatusRequest struct {
	*aws.Request
	Input *SetTaskStatusInput
	Copy  func(*SetTaskStatusInput) SetTaskStatusRequest
}

// Send marshals and sends the SetTaskStatus API request.
func (r SetTaskStatusRequest) Send(ctx context.Context) (*SetTaskStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetTaskStatusResponse{
		SetTaskStatusOutput: r.Request.Data.(*SetTaskStatusOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetTaskStatusResponse is the response type for the
// SetTaskStatus API operation.
type SetTaskStatusResponse struct {
	*SetTaskStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetTaskStatus request.
func (r *SetTaskStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
