// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dax

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/IncreaseReplicationFactorRequest
type IncreaseReplicationFactorInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zones (AZs) in which the cluster nodes will be created.
	// All nodes belonging to the cluster are placed in these Availability Zones.
	// Use this parameter if you want to distribute the nodes across multiple AZs.
	AvailabilityZones []string `type:"list"`

	// The name of the DAX cluster that will receive additional nodes.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The new number of nodes for the DAX cluster.
	//
	// NewReplicationFactor is a required field
	NewReplicationFactor *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s IncreaseReplicationFactorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseReplicationFactorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IncreaseReplicationFactorInput"}

	if s.ClusterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterName"))
	}

	if s.NewReplicationFactor == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewReplicationFactor"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/IncreaseReplicationFactorResponse
type IncreaseReplicationFactorOutput struct {
	_ struct{} `type:"structure"`

	// A description of the DAX cluster. with its new replication factor.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s IncreaseReplicationFactorOutput) String() string {
	return awsutil.Prettify(s)
}

const opIncreaseReplicationFactor = "IncreaseReplicationFactor"

// IncreaseReplicationFactorRequest returns a request value for making API operation for
// Amazon DynamoDB Accelerator (DAX).
//
// Adds one or more nodes to a DAX cluster.
//
//    // Example sending a request using IncreaseReplicationFactorRequest.
//    req := client.IncreaseReplicationFactorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/IncreaseReplicationFactor
func (c *Client) IncreaseReplicationFactorRequest(input *IncreaseReplicationFactorInput) IncreaseReplicationFactorRequest {
	op := &aws.Operation{
		Name:       opIncreaseReplicationFactor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IncreaseReplicationFactorInput{}
	}

	req := c.newRequest(op, input, &IncreaseReplicationFactorOutput{})
	return IncreaseReplicationFactorRequest{Request: req, Input: input, Copy: c.IncreaseReplicationFactorRequest}
}

// IncreaseReplicationFactorRequest is the request type for the
// IncreaseReplicationFactor API operation.
type IncreaseReplicationFactorRequest struct {
	*aws.Request
	Input *IncreaseReplicationFactorInput
	Copy  func(*IncreaseReplicationFactorInput) IncreaseReplicationFactorRequest
}

// Send marshals and sends the IncreaseReplicationFactor API request.
func (r IncreaseReplicationFactorRequest) Send(ctx context.Context) (*IncreaseReplicationFactorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &IncreaseReplicationFactorResponse{
		IncreaseReplicationFactorOutput: r.Request.Data.(*IncreaseReplicationFactorOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// IncreaseReplicationFactorResponse is the response type for the
// IncreaseReplicationFactor API operation.
type IncreaseReplicationFactorResponse struct {
	*IncreaseReplicationFactorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// IncreaseReplicationFactor request.
func (r *IncreaseReplicationFactorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
