// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the list unique problems operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblemsRequest
type ListUniqueProblemsInput struct {
	_ struct{} `type:"structure"`

	// The unique problems' ARNs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListUniqueProblemsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUniqueProblemsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListUniqueProblemsInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a list unique problems request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblemsResult
type ListUniqueProblemsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the unique problems.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	UniqueProblems map[string][]UniqueProblem `locationName:"uniqueProblems" type:"map"`
}

// String returns the string representation
func (s ListUniqueProblemsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListUniqueProblems = "ListUniqueProblems"

// ListUniqueProblemsRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about unique problems.
//
//    // Example sending a request using ListUniqueProblemsRequest.
//    req := client.ListUniqueProblemsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems
func (c *Client) ListUniqueProblemsRequest(input *ListUniqueProblemsInput) ListUniqueProblemsRequest {
	op := &aws.Operation{
		Name:       opListUniqueProblems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUniqueProblemsInput{}
	}

	req := c.newRequest(op, input, &ListUniqueProblemsOutput{})
	return ListUniqueProblemsRequest{Request: req, Input: input, Copy: c.ListUniqueProblemsRequest}
}

// ListUniqueProblemsRequest is the request type for the
// ListUniqueProblems API operation.
type ListUniqueProblemsRequest struct {
	*aws.Request
	Input *ListUniqueProblemsInput
	Copy  func(*ListUniqueProblemsInput) ListUniqueProblemsRequest
}

// Send marshals and sends the ListUniqueProblems API request.
func (r ListUniqueProblemsRequest) Send(ctx context.Context) (*ListUniqueProblemsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListUniqueProblemsResponse{
		ListUniqueProblemsOutput: r.Request.Data.(*ListUniqueProblemsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListUniqueProblemsRequestPaginator returns a paginator for ListUniqueProblems.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListUniqueProblemsRequest(input)
//   p := devicefarm.NewListUniqueProblemsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListUniqueProblemsPaginator(req ListUniqueProblemsRequest) ListUniqueProblemsPaginator {
	return ListUniqueProblemsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListUniqueProblemsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListUniqueProblemsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListUniqueProblemsPaginator struct {
	aws.Pager
}

func (p *ListUniqueProblemsPaginator) CurrentPage() *ListUniqueProblemsOutput {
	return p.Pager.CurrentPage().(*ListUniqueProblemsOutput)
}

// ListUniqueProblemsResponse is the response type for the
// ListUniqueProblems API operation.
type ListUniqueProblemsResponse struct {
	*ListUniqueProblemsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListUniqueProblems request.
func (r *ListUniqueProblemsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
