// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnectRequest
type AllocateConnectionOnInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The bandwidth of the connection. The possible values are 50Mbps, 100Mbps,
	// 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and 10Gbps. Note
	// that only those AWS Direct Connect Partners who have met specific requirements
	// are allowed to create a 1Gbps, 2Gbps, 5Gbps or 10Gbps hosted connection.
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the provisioned connection.
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// The ID of the interconnect on which the connection will be provisioned.
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// The ID of the AWS account of the customer for whom the connection will be
	// provisioned.
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	// The dedicated VLAN provisioned to the connection.
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateConnectionOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateConnectionOnInterconnectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AllocateConnectionOnInterconnectInput"}

	if s.Bandwidth == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bandwidth"))
	}

	if s.ConnectionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionName"))
	}

	if s.InterconnectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InterconnectId"))
	}

	if s.OwnerAccount == nil {
		invalidParams.Add(aws.NewErrParamRequired("OwnerAccount"))
	}

	if s.Vlan == nil {
		invalidParams.Add(aws.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about an AWS Direct Connect connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Connection
type AllocateConnectionOnInterconnectOutput struct {
	_ struct{} `type:"structure"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The Direct Connect endpoint on which the physical connection terminates.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The bandwidth of the connection.
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the connection.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The name of the connection.
	ConnectionName *string `locationName:"connectionName" type:"string"`

	// The state of the connection. The following are the possible values:
	//
	//    * ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * pending: The connection has been approved and is being initialized.
	//
	//    * available: The network link is up and the connection is ready for use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The connection is being deleted.
	//
	//    * deleted: The connection has been deleted.
	//
	//    * rejected: A hosted connection in the ordering state enters the rejected
	//    state if it is deleted by the customer.
	//
	//    * unknown: The state of the connection is not available.
	ConnectionState ConnectionState `locationName:"connectionState" type:"string" enum:"true"`

	// Indicates whether the connection supports a secondary BGP peer in the same
	// address family (IPv4/IPv6).
	HasLogicalRedundancy HasLogicalRedundancy `locationName:"hasLogicalRedundancy" type:"string" enum:"true"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The time of the most recent call to DescribeLoa for this connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp" timestampFormat:"unix"`

	// The location of the connection.
	Location *string `locationName:"location" type:"string"`

	// The ID of the AWS account that owns the connection.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the AWS Direct Connect service provider associated with the connection.
	PartnerName *string `locationName:"partnerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The ID of the VLAN.
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s AllocateConnectionOnInterconnectOutput) String() string {
	return awsutil.Prettify(s)
}

const opAllocateConnectionOnInterconnect = "AllocateConnectionOnInterconnect"

// AllocateConnectionOnInterconnectRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Deprecated. Use AllocateHostedConnection instead.
//
// Creates a hosted connection on an interconnect.
//
// Allocates a VLAN number and a specified amount of bandwidth for use by a
// hosted connection on the specified interconnect.
//
// Intended for use by AWS Direct Connect Partners only.
//
//    // Example sending a request using AllocateConnectionOnInterconnectRequest.
//    req := client.AllocateConnectionOnInterconnectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnect
func (c *Client) AllocateConnectionOnInterconnectRequest(input *AllocateConnectionOnInterconnectInput) AllocateConnectionOnInterconnectRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AllocateConnectionOnInterconnect, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opAllocateConnectionOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateConnectionOnInterconnectInput{}
	}

	req := c.newRequest(op, input, &AllocateConnectionOnInterconnectOutput{})
	return AllocateConnectionOnInterconnectRequest{Request: req, Input: input, Copy: c.AllocateConnectionOnInterconnectRequest}
}

// AllocateConnectionOnInterconnectRequest is the request type for the
// AllocateConnectionOnInterconnect API operation.
type AllocateConnectionOnInterconnectRequest struct {
	*aws.Request
	Input *AllocateConnectionOnInterconnectInput
	Copy  func(*AllocateConnectionOnInterconnectInput) AllocateConnectionOnInterconnectRequest
}

// Send marshals and sends the AllocateConnectionOnInterconnect API request.
func (r AllocateConnectionOnInterconnectRequest) Send(ctx context.Context) (*AllocateConnectionOnInterconnectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AllocateConnectionOnInterconnectResponse{
		AllocateConnectionOnInterconnectOutput: r.Request.Data.(*AllocateConnectionOnInterconnectOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AllocateConnectionOnInterconnectResponse is the response type for the
// AllocateConnectionOnInterconnect API operation.
type AllocateConnectionOnInterconnectResponse struct {
	*AllocateConnectionOnInterconnectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AllocateConnectionOnInterconnect request.
func (r *AllocateConnectionOnInterconnectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
