// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterfaceRequest
type CreateTransitVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Information about the transit virtual interface.
	//
	// NewTransitVirtualInterface is a required field
	NewTransitVirtualInterface *NewTransitVirtualInterface `locationName:"newTransitVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTransitVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTransitVirtualInterfaceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTransitVirtualInterfaceInput"}

	if s.ConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionId"))
	}

	if s.NewTransitVirtualInterface == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewTransitVirtualInterface"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterfaceResult
type CreateTransitVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// Information about a virtual interface.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s CreateTransitVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTransitVirtualInterface = "CreateTransitVirtualInterface"

// CreateTransitVirtualInterfaceRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Creates a transit virtual interface. A transit virtual interface is a VLAN
// that transports traffic from a Direct Connect gateway to one or more transit
// gateways. A transit virtual interface enables the connection of multiple
// VPCs attached to a transit gateway to a Direct Connect gateway.
//
//    // Example sending a request using CreateTransitVirtualInterfaceRequest.
//    req := client.CreateTransitVirtualInterfaceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterface
func (c *Client) CreateTransitVirtualInterfaceRequest(input *CreateTransitVirtualInterfaceInput) CreateTransitVirtualInterfaceRequest {
	op := &aws.Operation{
		Name:       opCreateTransitVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitVirtualInterfaceInput{}
	}

	req := c.newRequest(op, input, &CreateTransitVirtualInterfaceOutput{})
	return CreateTransitVirtualInterfaceRequest{Request: req, Input: input, Copy: c.CreateTransitVirtualInterfaceRequest}
}

// CreateTransitVirtualInterfaceRequest is the request type for the
// CreateTransitVirtualInterface API operation.
type CreateTransitVirtualInterfaceRequest struct {
	*aws.Request
	Input *CreateTransitVirtualInterfaceInput
	Copy  func(*CreateTransitVirtualInterfaceInput) CreateTransitVirtualInterfaceRequest
}

// Send marshals and sends the CreateTransitVirtualInterface API request.
func (r CreateTransitVirtualInterfaceRequest) Send(ctx context.Context) (*CreateTransitVirtualInterfaceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTransitVirtualInterfaceResponse{
		CreateTransitVirtualInterfaceOutput: r.Request.Data.(*CreateTransitVirtualInterfaceOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTransitVirtualInterfaceResponse is the response type for the
// CreateTransitVirtualInterface API operation.
type CreateTransitVirtualInterfaceResponse struct {
	*CreateTransitVirtualInterfaceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTransitVirtualInterface request.
func (r *CreateTransitVirtualInterfaceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
