// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package docdb

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about an Availability Zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// The configuration setting for the log types to be enabled for export to Amazon
// CloudWatch Logs for a specific DB instance or DB cluster.
//
// The EnableLogTypes and DisableLogTypes arrays determine which logs are exported
// (or not exported) to CloudWatch Logs. The values within these arrays depend
// on the DB engine that is being used.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CloudwatchLogsExportConfiguration
type CloudwatchLogsExportConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of log types to disable.
	DisableLogTypes []string `type:"list"`

	// The list of log types to enable.
	EnableLogTypes []string `type:"list"`
}

// String returns the string representation
func (s CloudwatchLogsExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a DB cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBCluster
type DBCluster struct {
	_ struct{} `type:"structure"`

	// Provides a list of the AWS Identity and Access Management (IAM) roles that
	// are associated with the DB cluster. IAM roles that are associated with a
	// DB cluster grant permission for the DB cluster to access other AWS services
	// on your behalf.
	AssociatedRoles []DBClusterRole `locationNameList:"DBClusterRole" type:"list"`

	// Provides the list of Amazon EC2 Availability Zones that instances in the
	// DB cluster can be created in.
	AvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string `type:"string"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group that is associated with the DB
	// cluster, including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// The AWS Region-unique, immutable identifier for the DB cluster. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// cluster is accessed.
	DbClusterResourceId *string `type:"string"`

	// The earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of log types that this DB cluster is configured to export to Amazon
	// CloudWatch Logs.
	EnabledCloudwatchLogsExports []string `type:"list"`

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Contains the master user name for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool `type:"boolean"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load balances connections across the Amazon DocumentDB replicas that are
	// available in a DB cluster. As clients request new connections to the reader
	// endpoint, Amazon DocumentDB distributes the connection requests among the
	// Amazon DocumentDB replicas in the DB cluster. This functionality can help
	// balance your read workload across multiple Amazon DocumentDB replicas in
	// your DB cluster.
	//
	// If a failover occurs, and the Amazon DocumentDB replica that you are connected
	// to is promoted to be the primary instance, your connection is dropped. To
	// continue sending your read workload to other Amazon DocumentDB replicas in
	// the cluster, you can then reconnect to the reader endpoint.
	ReaderEndpoint *string `type:"string"`

	// Specifies the current state of this DB cluster.
	Status *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of virtual private cloud (VPC) security groups that the DB
	// cluster belongs to.
	VpcSecurityGroups []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an instance that is part of a DB cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBClusterMember
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the DB cluster parameter group for this member of
	// the DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string `type:"string"`

	// A value that is true if the cluster member is the primary instance for the
	// DB cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`

	// A value that specifies the order in which an Amazon DocumentDB replica is
	// promoted to the primary instance after a failure of the existing primary
	// instance.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a DB cluster parameter group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBClusterParameterGroup
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string `type:"string"`

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this DB cluster parameter
	// group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBClusterRole
type DBClusterRole struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB cluster.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB cluster.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - The IAM role ARN is associated with the DB cluster and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - The IAM role ARN is being associated with the DB cluster.
	//
	//    * INVALID - The IAM role ARN is associated with the DB cluster, but the
	//    DB cluster cannot assume the IAM role to access other AWS services on
	//    your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterRole) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a DB cluster snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBClusterSnapshot
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Provides the list of Amazon EC2 Availability Zones that instances in the
	// DB cluster snapshot can be restored in.
	AvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string `type:"string"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the master user name for the DB cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in UTC.
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// If the DB cluster snapshot was copied from a source DB cluster snapshot,
	// the ARN for the source DB cluster snapshot; otherwise, a null value.
	SourceDBClusterSnapshotArn *string `type:"string"`

	// Specifies the status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the virtual private cloud (VPC) ID that is associated with the DB
	// cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// Contains the name and values of a manual DB cluster snapshot attribute.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to restore a manual DB cluster snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBClusterSnapshotAttribute
type DBClusterSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot.
	AttributeName *string `type:"string"`

	// The values for the manual DB cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB cluster snapshot. If a value of all is in the list, then the manual
	// DB cluster snapshot is public and available for any AWS account to copy or
	// restore.
	AttributeValues []string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBClusterSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about the attributes that are associated with a DB cluster
// snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBClusterSnapshotAttributesResult
type DBClusterSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the DB cluster snapshot.
	DBClusterSnapshotAttributes []DBClusterSnapshotAttribute `locationNameList:"DBClusterSnapshotAttribute" type:"list"`

	// The identifier of the DB cluster snapshot that the attributes apply to.
	DBClusterSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a DB engine version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBEngineVersion
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// The types of logs that the database engine has available for export to Amazon
	// CloudWatch Logs.
	ExportableLogTypes []string `type:"list"`

	// A value that indicates whether the engine version supports exporting the
	// log types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs *bool `type:"boolean"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a DB instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBInstance
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone that the DB instance is located
	// in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Contains the name of the DB cluster that the DB instance is a member of if
	// the DB instance is a member of a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-provided database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	DBInstanceStatus *string `type:"string"`

	// Specifies information on the subnet group that is associated with the DB
	// instance, including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// A list of log types that this DB instance is configured to export to Amazon
	// CloudWatch Logs.
	EnabledCloudwatchLogsExports []string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Provides the date and time that the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies that changes to the DB instance are pending. This element is included
	// only when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Amazon DocumentDB replica is
	// promoted to the primary instance after a failure of the existing primary
	// instance.
	PromotionTier *int64 `type:"integer"`

	// Specifies the availability options for the DB instance. A value of true specifies
	// an internet-facing instance with a publicly resolvable DNS name, which resolves
	// to a public IP address. A value of false specifies an internal instance with
	// a DNS name that resolves to a private IP address.
	PubliclyAccessible *bool `type:"boolean"`

	// The status of a read replica. If the instance is not a read replica, this
	// is blank.
	StatusInfos []DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security group elements that the DB instance belongs
	// to.
	VpcSecurityGroups []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// Provides a list of status information for a DB instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBInstanceStatusInfo
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// is not in an error state, this value is blank.
	Message *string `type:"string"`

	// A Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the DB instance. For a StatusType of read replica, the values can
	// be replicating, error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a DB subnet group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DBSubnetGroup
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Identifier (ARN) for the DB subnet group.
	DBSubnetGroupArn *string `type:"string"`

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name of the DB subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Detailed information about one or more subnets within a DB subnet group.
	Subnets []Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the virtual private cloud (VPC) ID of the DB subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// Network information for accessing a DB cluster or DB instance. Client programs
// must specify a valid endpoint to access these Amazon DocumentDB resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/Endpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// Contains the result of a successful invocation of the DescribeEngineDefaultClusterParameters
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/EngineDefaults
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group family to return the engine parameter
	// information for.
	DBParameterGroupFamily *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The parameters of a particular DB cluster parameter group family.
	Parameters []Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about an event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/Event
type Event struct {
	_ struct{} `type:"structure"`

	// Specifies the date and time of the event.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the category for the event.
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// Provides the text of this event.
	Message *string `type:"string"`

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string `type:"string"`

	// Provides the identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// Specifies the source type for this event.
	SourceType SourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// An event source type, accompanied by one or more event category names.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/EventCategoriesMap
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The event categories for the specified source type.
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// The source type that the returned categories belong to.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// A named set of filter values, used to return a more specific list of results.
// You can use a filter to match a set of resources by specific criteria, such
// as IDs.
//
// Wildcards are not supported in filters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// One or more filter values. Filter values are case sensitive.
	//
	// Values is a required field
	Values []string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The options that are available for a DB instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/OrderableDBInstanceOption
type OrderableDBInstanceOption struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones for a DB instance.
	AvailabilityZones []AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The DB instance class for a DB instance.
	DBInstanceClass *string `type:"string"`

	// The engine type of a DB instance.
	Engine *string `type:"string"`

	// The engine version of a DB instance.
	EngineVersion *string `type:"string"`

	// The license model for a DB instance.
	LicenseModel *string `type:"string"`

	// Indicates whether a DB instance is in a virtual private cloud (VPC).
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s OrderableDBInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about an individual parameter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/Parameter
type Parameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates when to apply parameter updates.
	ApplyMethod ApplyMethod `type:"string" enum:"true"`

	// Specifies the engine-specific parameters type.
	ApplyType *string `type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `type:"string"`

	// Provides a description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// Specifies the name of the parameter.
	ParameterName *string `type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `type:"string"`

	// Indicates the source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// A list of the log types whose configuration is still pending. These log types
// are in the process of being activated or deactivated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/PendingCloudwatchLogsExports
type PendingCloudwatchLogsExports struct {
	_ struct{} `type:"structure"`

	// Log types that are in the process of being enabled. After they are enabled,
	// these log types are exported to Amazon CloudWatch Logs.
	LogTypesToDisable []string `type:"list"`

	// Log types that are in the process of being deactivated. After they are deactivated,
	// these log types aren't exported to CloudWatch Logs.
	LogTypesToEnable []string `type:"list"`
}

// String returns the string representation
func (s PendingCloudwatchLogsExports) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a pending maintenance action for a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/PendingMaintenanceAction
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action is applied. The maintenance
	// action is applied to the resource during its first maintenance window after
	// this date. If this date is specified, any next-maintenance opt-in requests
	// are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The effective date when the pending maintenance action is applied to the
	// resource.
	CurrentApplyDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action is automatically applied. The maintenance
	// action is applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// One or more modified settings for a DB instance. These modified settings
// have been requested, but haven't been applied yet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/PendingModifiedValues
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// Contains the new AllocatedStorage size for the DB instance that will be applied
	// or is currently being applied.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the identifier of the certificate authority (CA) certificate for
	// the DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the new DBInstanceClass for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceClass *string `type:"string"`

	// Contains the new DBInstanceIdentifier for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceIdentifier *string `type:"string"`

	// The new DB subnet group for the DB instance.
	DBSubnetGroupName *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the new Provisioned IOPS value for the DB instance that will be
	// applied or is currently being applied.
	Iops *int64 `type:"integer"`

	// The license model for the DB instance.
	//
	// Valid values: license-included, bring-your-own-license, general-public-license
	LicenseModel *string `type:"string"`

	// Contains the pending or currently in-progress change of the master credentials
	// for the DB instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// A list of the log types whose configuration is still pending. These log types
	// are in the process of being activated or deactivated.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports `type:"structure"`

	// Specifies the pending port for the DB instance.
	Port *int64 `type:"integer"`

	// Specifies the storage type to be associated with the DB instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of ApplyPendingMaintenanceAction.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ResourcePendingMaintenanceActions
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []PendingMaintenanceAction `locationNameList:"PendingMaintenanceAction" type:"list"`

	// The Amazon Resource Name (ARN) of the resource that has pending maintenance
	// actions.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a subnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/Subnet
type Subnet struct {
	_ struct{} `type:"structure"`

	// Specifies the Availability Zone for the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// Specifies the identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// Specifies the status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// Metadata assigned to an Amazon DocumentDB resource consisting of a key-value
// pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The required name of the tag. The string value can be from 1 to 128 Unicode
	// characters in length and can't be prefixed with "aws:" or "rds:". The string
	// can contain only the set of Unicode letters, digits, white space, '_', '.',
	// '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// The optional value of the tag. The string value can be from 1 to 256 Unicode
	// characters in length and can't be prefixed with "aws:" or "rds:". The string
	// can contain only the set of Unicode letters, digits, white space, '_', '.',
	// '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// The version of the database engine that a DB instance can be upgraded to.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/UpgradeTarget
type UpgradeTarget struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether the target version is applied to any source
	// DB instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade *bool `type:"boolean"`

	// The version of the database engine that a DB instance can be upgraded to.
	Description *string `type:"string"`

	// The name of the upgrade target database engine.
	Engine *string `type:"string"`

	// The version number of the upgrade target database engine.
	EngineVersion *string `type:"string"`

	// A value that indicates whether a database engine is upgraded to a major version.
	IsMajorVersionUpgrade *bool `type:"boolean"`
}

// String returns the string representation
func (s UpgradeTarget) String() string {
	return awsutil.Prettify(s)
}

// Used as a response element for queries on virtual private cloud (VPC) security
// group membership.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/VpcSecurityGroupMembership
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}
