// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewaysRequest
type DescribeTransitGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters. The possible values are:
	//
	//    * options.propagation-default-route-table-id - The ID of the default propagation
	//    route table.
	//
	//    * options.amazon-side-asn - The private ASN for the Amazon side of a BGP
	//    session.
	//
	//    * options.association-default-route-table-id - The ID of the default association
	//    route table.
	//
	//    * options.auto-accept-shared-attachments - Indicates whether there is
	//    automatic acceptance of attachment requests (enable | disable).
	//
	//    * options.default-route-table-association - Indicates whether resource
	//    attachments are automatically associated with the default association
	//    route table (enable | disable).
	//
	//    * options.default-route-table-propagation - Indicates whether resource
	//    attachments automatically propagate routes to the default propagation
	//    route table (enable | disable).
	//
	//    * options.dns-support - Indicates whether DNS support is enabled (enable
	//    | disable).
	//
	//    * options.vpn-ecmp-support - Indicates whether Equal Cost Multipath Protocol
	//    support is enabled (enable | disable).
	//
	//    * owner-id - The ID of the AWS account that owns the transit gateway.
	//
	//    * state - The state of the attachment (available | deleted | deleting
	//    | failed | modifying | pendingAcceptance | pending | rollingBack | rejected
	//    | rejecting).
	//
	//    * transit-gateway-id - The ID of the transit gateway.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The IDs of the transit gateways.
	TransitGatewayIds []string `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTransitGatewaysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTransitGatewaysInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewaysResult
type DescribeTransitGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the transit gateways.
	TransitGateways []TransitGateway `locationName:"transitGatewaySet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTransitGateways = "DescribeTransitGateways"

// DescribeTransitGatewaysRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more transit gateways. By default, all transit gateways
// are described. Alternatively, you can filter the results.
//
//    // Example sending a request using DescribeTransitGatewaysRequest.
//    req := client.DescribeTransitGatewaysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGateways
func (c *Client) DescribeTransitGatewaysRequest(input *DescribeTransitGatewaysInput) DescribeTransitGatewaysRequest {
	op := &aws.Operation{
		Name:       opDescribeTransitGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTransitGatewaysInput{}
	}

	req := c.newRequest(op, input, &DescribeTransitGatewaysOutput{})
	return DescribeTransitGatewaysRequest{Request: req, Input: input, Copy: c.DescribeTransitGatewaysRequest}
}

// DescribeTransitGatewaysRequest is the request type for the
// DescribeTransitGateways API operation.
type DescribeTransitGatewaysRequest struct {
	*aws.Request
	Input *DescribeTransitGatewaysInput
	Copy  func(*DescribeTransitGatewaysInput) DescribeTransitGatewaysRequest
}

// Send marshals and sends the DescribeTransitGateways API request.
func (r DescribeTransitGatewaysRequest) Send(ctx context.Context) (*DescribeTransitGatewaysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTransitGatewaysResponse{
		DescribeTransitGatewaysOutput: r.Request.Data.(*DescribeTransitGatewaysOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeTransitGatewaysRequestPaginator returns a paginator for DescribeTransitGateways.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeTransitGatewaysRequest(input)
//   p := ec2.NewDescribeTransitGatewaysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeTransitGatewaysPaginator(req DescribeTransitGatewaysRequest) DescribeTransitGatewaysPaginator {
	return DescribeTransitGatewaysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeTransitGatewaysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeTransitGatewaysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeTransitGatewaysPaginator struct {
	aws.Pager
}

func (p *DescribeTransitGatewaysPaginator) CurrentPage() *DescribeTransitGatewaysOutput {
	return p.Pager.CurrentPage().(*DescribeTransitGatewaysOutput)
}

// DescribeTransitGatewaysResponse is the response type for the
// DescribeTransitGateways API operation.
type DescribeTransitGatewaysResponse struct {
	*DescribeTransitGatewaysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTransitGateways request.
func (r *DescribeTransitGatewaysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
