// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableEbsEncryptionByDefaultRequest
type DisableEbsEncryptionByDefaultInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`
}

// String returns the string representation
func (s DisableEbsEncryptionByDefaultInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableEbsEncryptionByDefaultResult
type DisableEbsEncryptionByDefaultOutput struct {
	_ struct{} `type:"structure"`

	// Account-level encryption status after performing the action.
	EbsEncryptionByDefault *bool `locationName:"ebsEncryptionByDefault" type:"boolean"`
}

// String returns the string representation
func (s DisableEbsEncryptionByDefaultOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableEbsEncryptionByDefault = "DisableEbsEncryptionByDefault"

// DisableEbsEncryptionByDefaultRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disables default encryption for EBS volumes that are created in your account
// in the current region.
//
// Call this API if you have enabled default encryption using EnableEbsEncryptionByDefault
// and want to disable default EBS encryption. Once default EBS encryption is
// disabled, you can still create an encrypted volume by setting encrypted to
// true in the API call that creates the volume.
//
// Disabling default EBS encryption will not change the encryption status of
// any of your existing volumes.
//
//    // Example sending a request using DisableEbsEncryptionByDefaultRequest.
//    req := client.DisableEbsEncryptionByDefaultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableEbsEncryptionByDefault
func (c *Client) DisableEbsEncryptionByDefaultRequest(input *DisableEbsEncryptionByDefaultInput) DisableEbsEncryptionByDefaultRequest {
	op := &aws.Operation{
		Name:       opDisableEbsEncryptionByDefault,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableEbsEncryptionByDefaultInput{}
	}

	req := c.newRequest(op, input, &DisableEbsEncryptionByDefaultOutput{})
	return DisableEbsEncryptionByDefaultRequest{Request: req, Input: input, Copy: c.DisableEbsEncryptionByDefaultRequest}
}

// DisableEbsEncryptionByDefaultRequest is the request type for the
// DisableEbsEncryptionByDefault API operation.
type DisableEbsEncryptionByDefaultRequest struct {
	*aws.Request
	Input *DisableEbsEncryptionByDefaultInput
	Copy  func(*DisableEbsEncryptionByDefaultInput) DisableEbsEncryptionByDefaultRequest
}

// Send marshals and sends the DisableEbsEncryptionByDefault API request.
func (r DisableEbsEncryptionByDefaultRequest) Send(ctx context.Context) (*DisableEbsEncryptionByDefaultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableEbsEncryptionByDefaultResponse{
		DisableEbsEncryptionByDefaultOutput: r.Request.Data.(*DisableEbsEncryptionByDefaultOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableEbsEncryptionByDefaultResponse is the response type for the
// DisableEbsEncryptionByDefault API operation.
type DisableEbsEncryptionByDefaultResponse struct {
	*DisableEbsEncryptionByDefaultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableEbsEncryptionByDefault request.
func (r *DisableEbsEncryptionByDefaultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
