// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Contains the parameters for DisableVgwRoutePropagation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVgwRoutePropagationRequest
type DisableVgwRoutePropagationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway.
	//
	// GatewayId is a required field
	GatewayId *string `type:"string" required:"true"`

	// The ID of the route table.
	//
	// RouteTableId is a required field
	RouteTableId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableVgwRoutePropagationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableVgwRoutePropagationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableVgwRoutePropagationInput"}

	if s.GatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayId"))
	}

	if s.RouteTableId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVgwRoutePropagationOutput
type DisableVgwRoutePropagationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableVgwRoutePropagationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableVgwRoutePropagation = "DisableVgwRoutePropagation"

// DisableVgwRoutePropagationRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disables a virtual private gateway (VGW) from propagating routes to a specified
// route table of a VPC.
//
//    // Example sending a request using DisableVgwRoutePropagationRequest.
//    req := client.DisableVgwRoutePropagationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVgwRoutePropagation
func (c *Client) DisableVgwRoutePropagationRequest(input *DisableVgwRoutePropagationInput) DisableVgwRoutePropagationRequest {
	op := &aws.Operation{
		Name:       opDisableVgwRoutePropagation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableVgwRoutePropagationInput{}
	}

	req := c.newRequest(op, input, &DisableVgwRoutePropagationOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DisableVgwRoutePropagationRequest{Request: req, Input: input, Copy: c.DisableVgwRoutePropagationRequest}
}

// DisableVgwRoutePropagationRequest is the request type for the
// DisableVgwRoutePropagation API operation.
type DisableVgwRoutePropagationRequest struct {
	*aws.Request
	Input *DisableVgwRoutePropagationInput
	Copy  func(*DisableVgwRoutePropagationInput) DisableVgwRoutePropagationRequest
}

// Send marshals and sends the DisableVgwRoutePropagation API request.
func (r DisableVgwRoutePropagationRequest) Send(ctx context.Context) (*DisableVgwRoutePropagationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableVgwRoutePropagationResponse{
		DisableVgwRoutePropagationOutput: r.Request.Data.(*DisableVgwRoutePropagationOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableVgwRoutePropagationResponse is the response type for the
// DisableVgwRoutePropagation API operation.
type DisableVgwRoutePropagationResponse struct {
	*DisableVgwRoutePropagationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableVgwRoutePropagation request.
func (r *DisableVgwRoutePropagationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
