// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayerRequest
type GetDownloadUrlForLayerInput struct {
	_ struct{} `type:"structure"`

	// The digest of the image layer to download.
	//
	// LayerDigest is a required field
	LayerDigest *string `locationName:"layerDigest" type:"string" required:"true"`

	// The AWS account ID associated with the registry that contains the image layer
	// to download. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the image layer to download.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDownloadUrlForLayerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDownloadUrlForLayerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDownloadUrlForLayerInput"}

	if s.LayerDigest == nil {
		invalidParams.Add(aws.NewErrParamRequired("LayerDigest"))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayerResponse
type GetDownloadUrlForLayerOutput struct {
	_ struct{} `type:"structure"`

	// The pre-signed Amazon S3 download URL for the requested layer.
	DownloadUrl *string `locationName:"downloadUrl" type:"string"`

	// The digest of the image layer to download.
	LayerDigest *string `locationName:"layerDigest" type:"string"`
}

// String returns the string representation
func (s GetDownloadUrlForLayerOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDownloadUrlForLayer = "GetDownloadUrlForLayer"

// GetDownloadUrlForLayerRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Retrieves the pre-signed Amazon S3 download URL corresponding to an image
// layer. You can only get URLs for image layers that are referenced in an image.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
//    // Example sending a request using GetDownloadUrlForLayerRequest.
//    req := client.GetDownloadUrlForLayerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayer
func (c *Client) GetDownloadUrlForLayerRequest(input *GetDownloadUrlForLayerInput) GetDownloadUrlForLayerRequest {
	op := &aws.Operation{
		Name:       opGetDownloadUrlForLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDownloadUrlForLayerInput{}
	}

	req := c.newRequest(op, input, &GetDownloadUrlForLayerOutput{})
	return GetDownloadUrlForLayerRequest{Request: req, Input: input, Copy: c.GetDownloadUrlForLayerRequest}
}

// GetDownloadUrlForLayerRequest is the request type for the
// GetDownloadUrlForLayer API operation.
type GetDownloadUrlForLayerRequest struct {
	*aws.Request
	Input *GetDownloadUrlForLayerInput
	Copy  func(*GetDownloadUrlForLayerInput) GetDownloadUrlForLayerRequest
}

// Send marshals and sends the GetDownloadUrlForLayer API request.
func (r GetDownloadUrlForLayerRequest) Send(ctx context.Context) (*GetDownloadUrlForLayerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDownloadUrlForLayerResponse{
		GetDownloadUrlForLayerOutput: r.Request.Data.(*GetDownloadUrlForLayerOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDownloadUrlForLayerResponse is the response type for the
// GetDownloadUrlForLayer API operation.
type GetDownloadUrlForLayerResponse struct {
	*GetDownloadUrlForLayerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDownloadUrlForLayer request.
func (r *GetDownloadUrlForLayerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
