// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAttributesRequest
type DeleteAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes to delete from your resource. You can specify up to 10 attributes
	// per request. For custom attributes, specify the attribute name and target
	// ID, but do not specify the value. If you specify the target ID using the
	// short form, you must also specify the target type.
	//
	// Attributes is a required field
	Attributes []Attribute `locationName:"attributes" type:"list" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that contains
	// the resource to delete attributes. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`
}

// String returns the string representation
func (s DeleteAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAttributesInput"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAttributesResponse
type DeleteAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A list of attribute objects that were successfully deleted from your resource.
	Attributes []Attribute `locationName:"attributes" type:"list"`
}

// String returns the string representation
func (s DeleteAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAttributes = "DeleteAttributes"

// DeleteAttributesRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Deletes one or more custom attributes from an Amazon ECS resource.
//
//    // Example sending a request using DeleteAttributesRequest.
//    req := client.DeleteAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAttributes
func (c *Client) DeleteAttributesRequest(input *DeleteAttributesInput) DeleteAttributesRequest {
	op := &aws.Operation{
		Name:       opDeleteAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAttributesInput{}
	}

	req := c.newRequest(op, input, &DeleteAttributesOutput{})
	return DeleteAttributesRequest{Request: req, Input: input, Copy: c.DeleteAttributesRequest}
}

// DeleteAttributesRequest is the request type for the
// DeleteAttributes API operation.
type DeleteAttributesRequest struct {
	*aws.Request
	Input *DeleteAttributesInput
	Copy  func(*DeleteAttributesInput) DeleteAttributesRequest
}

// Send marshals and sends the DeleteAttributes API request.
func (r DeleteAttributesRequest) Send(ctx context.Context) (*DeleteAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAttributesResponse{
		DeleteAttributesOutput: r.Request.Data.(*DeleteAttributesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAttributesResponse is the response type for the
// DeleteAttributes API operation.
type DeleteAttributesResponse struct {
	*DeleteAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAttributes request.
func (r *DeleteAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
