// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a RebootCacheCluster operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheClusterMessage
type RebootCacheClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is stored as a lowercase string.
	//
	// CacheClusterId is a required field
	CacheClusterId *string `type:"string" required:"true"`

	// A list of cache node IDs to reboot. A node ID is a numeric identifier (0001,
	// 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.
	//
	// CacheNodeIdsToReboot is a required field
	CacheNodeIdsToReboot []string `locationNameList:"CacheNodeId" type:"list" required:"true"`
}

// String returns the string representation
func (s RebootCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootCacheClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebootCacheClusterInput"}

	if s.CacheClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CacheClusterId"))
	}

	if s.CacheNodeIdsToReboot == nil {
		invalidParams.Add(aws.NewErrParamRequired("CacheNodeIdsToReboot"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheClusterResult
type RebootCacheClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific cluster.
	CacheCluster *CacheCluster `type:"structure"`
}

// String returns the string representation
func (s RebootCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opRebootCacheCluster = "RebootCacheCluster"

// RebootCacheClusterRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Reboots some, or all, of the cache nodes within a provisioned cluster. This
// operation applies any modified cache parameter groups to the cluster. The
// reboot operation takes place as soon as possible, and results in a momentary
// outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
//
// The reboot causes the contents of the cache (for each cache node being rebooted)
// to be lost.
//
// When the reboot is complete, a cluster event is created.
//
// Rebooting a cluster is currently supported on Memcached and Redis (cluster
// mode disabled) clusters. Rebooting is not supported on Redis (cluster mode
// enabled) clusters.
//
// If you make changes to parameters that require a Redis (cluster mode enabled)
// cluster reboot for the changes to be applied, see Rebooting a Cluster (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html)
// for an alternate process.
//
//    // Example sending a request using RebootCacheClusterRequest.
//    req := client.RebootCacheClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheCluster
func (c *Client) RebootCacheClusterRequest(input *RebootCacheClusterInput) RebootCacheClusterRequest {
	op := &aws.Operation{
		Name:       opRebootCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootCacheClusterInput{}
	}

	req := c.newRequest(op, input, &RebootCacheClusterOutput{})
	return RebootCacheClusterRequest{Request: req, Input: input, Copy: c.RebootCacheClusterRequest}
}

// RebootCacheClusterRequest is the request type for the
// RebootCacheCluster API operation.
type RebootCacheClusterRequest struct {
	*aws.Request
	Input *RebootCacheClusterInput
	Copy  func(*RebootCacheClusterInput) RebootCacheClusterRequest
}

// Send marshals and sends the RebootCacheCluster API request.
func (r RebootCacheClusterRequest) Send(ctx context.Context) (*RebootCacheClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RebootCacheClusterResponse{
		RebootCacheClusterOutput: r.Request.Data.(*RebootCacheClusterOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RebootCacheClusterResponse is the response type for the
// RebootCacheCluster API operation.
type RebootCacheClusterResponse struct {
	*RebootCacheClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RebootCacheCluster request.
func (r *RebootCacheClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
