// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes the properties of an application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplicationDescription
type ApplicationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationArn *string `type:"string"`

	// The name of the application.
	ApplicationName *string `min:"1" type:"string"`

	// The names of the configuration templates associated with this application.
	ConfigurationTemplates []string `type:"list"`

	// The date when the application was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date when the application was last modified.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// User-defined description of the application.
	Description *string `type:"string"`

	// The lifecycle settings for the application.
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig `type:"structure"`

	// The names of the versions for this application.
	Versions []string `type:"list"`
}

// String returns the string representation
func (s ApplicationDescription) String() string {
	return awsutil.Prettify(s)
}

// Application request metrics for an AWS Elastic Beanstalk environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplicationMetrics
type ApplicationMetrics struct {
	_ struct{} `type:"structure"`

	// The amount of time that the metrics cover (usually 10 seconds). For example,
	// you might have 5 requests (request_count) within the most recent time slice
	// of 10 seconds (duration).
	Duration *int64 `type:"integer"`

	// Represents the average latency for the slowest X percent of requests over
	// the last 10 seconds. Latencies are in seconds with one millisecond resolution.
	Latency *Latency `type:"structure"`

	// Average number of requests handled by the web server per second over the
	// last 10 seconds.
	RequestCount *int64 `type:"integer"`

	// Represents the percentage of requests over the last 10 seconds that resulted
	// in each type of status code response.
	StatusCodes *StatusCodes `type:"structure"`
}

// String returns the string representation
func (s ApplicationMetrics) String() string {
	return awsutil.Prettify(s)
}

// The resource lifecycle configuration for an application. Defines lifecycle
// settings for resources that belong to the application, and the service role
// that Elastic Beanstalk assumes in order to apply lifecycle settings. The
// version lifecycle configuration defines lifecycle settings for application
// versions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplicationResourceLifecycleConfig
type ApplicationResourceLifecycleConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
	//
	// The ServiceRole property is required the first time that you provide a VersionLifecycleConfig
	// for the application in one of the supporting calls (CreateApplication or
	// UpdateApplicationResourceLifecycle). After you provide it once, in either
	// one of the calls, Elastic Beanstalk persists the Service Role with the application,
	// and you don't need to specify it again in subsequent UpdateApplicationResourceLifecycle
	// calls. You can, however, specify it in subsequent calls to change the Service
	// Role to another value.
	ServiceRole *string `type:"string"`

	// The application version lifecycle configuration.
	VersionLifecycleConfig *ApplicationVersionLifecycleConfig `type:"structure"`
}

// String returns the string representation
func (s ApplicationResourceLifecycleConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationResourceLifecycleConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationResourceLifecycleConfig"}
	if s.VersionLifecycleConfig != nil {
		if err := s.VersionLifecycleConfig.Validate(); err != nil {
			invalidParams.AddNested("VersionLifecycleConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the properties of an application version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplicationVersionDescription
type ApplicationVersionDescription struct {
	_ struct{} `type:"structure"`

	// The name of the application to which the application version belongs.
	ApplicationName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the application version.
	ApplicationVersionArn *string `type:"string"`

	// Reference to the artifact from the AWS CodeBuild build.
	BuildArn *string `type:"string"`

	// The creation date of the application version.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The last modified date of the application version.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the application version.
	Description *string `type:"string"`

	// If the version's source code was retrieved from AWS CodeCommit, the location
	// of the source code for the application version.
	SourceBuildInformation *SourceBuildInformation `type:"structure"`

	// The storage location of the application version's source bundle in Amazon
	// S3.
	SourceBundle *S3Location `type:"structure"`

	// The processing status of the application version. Reflects the state of the
	// application version during its creation. Many of the values are only applicable
	// if you specified True for the Process parameter of the CreateApplicationVersion
	// action. The following list describes the possible values.
	//
	//    * Unprocessed – Application version wasn't pre-processed or validated.
	//    Elastic Beanstalk will validate configuration files during deployment
	//    of the application version to an environment.
	//
	//    * Processing – Elastic Beanstalk is currently processing the application
	//    version.
	//
	//    * Building – Application version is currently undergoing an AWS CodeBuild
	//    build.
	//
	//    * Processed – Elastic Beanstalk was successfully pre-processed and validated.
	//
	//    * Failed – Either the AWS CodeBuild build failed or configuration files
	//    didn't pass validation. This application version isn't usable.
	Status ApplicationVersionStatus `type:"string" enum:"true"`

	// A unique identifier for the application version.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ApplicationVersionDescription) String() string {
	return awsutil.Prettify(s)
}

// The application version lifecycle settings for an application. Defines the
// rules that Elastic Beanstalk applies to an application's versions in order
// to avoid hitting the per-region limit for application versions.
//
// When Elastic Beanstalk deletes an application version from its database,
// you can no longer deploy that version to an environment. The source bundle
// remains in S3 unless you configure the rule to delete it.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplicationVersionLifecycleConfig
type ApplicationVersionLifecycleConfig struct {
	_ struct{} `type:"structure"`

	// Specify a max age rule to restrict the length of time that application versions
	// are retained for an application.
	MaxAgeRule *MaxAgeRule `type:"structure"`

	// Specify a max count rule to restrict the number of application versions that
	// are retained for an application.
	MaxCountRule *MaxCountRule `type:"structure"`
}

// String returns the string representation
func (s ApplicationVersionLifecycleConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationVersionLifecycleConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationVersionLifecycleConfig"}
	if s.MaxAgeRule != nil {
		if err := s.MaxAgeRule.Validate(); err != nil {
			invalidParams.AddNested("MaxAgeRule", err.(aws.ErrInvalidParams))
		}
	}
	if s.MaxCountRule != nil {
		if err := s.MaxCountRule.Validate(); err != nil {
			invalidParams.AddNested("MaxCountRule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an Auto Scaling launch configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AutoScalingGroup
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The name of the AutoScalingGroup .
	Name *string `type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// Settings for an AWS CodeBuild build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/BuildConfiguration
type BuildConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk
	// stores the build artifact in the S3 location S3-bucket/resources/application-name/codebuild/codebuild-version-label-artifact-name.zip.
	// If not provided, Elastic Beanstalk stores the build artifact in the S3 location
	// S3-bucket/resources/application-name/codebuild/codebuild-version-label.zip.
	ArtifactName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that enables AWS CodeBuild to interact with dependent AWS services
	// on behalf of the AWS account.
	//
	// CodeBuildServiceRole is a required field
	CodeBuildServiceRole *string `type:"string" required:"true"`

	// Information about the compute resources the build project will use.
	//
	//    * BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds
	//
	//    * BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds
	//
	//    * BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds
	ComputeType ComputeType `type:"string" enum:"true"`

	// The ID of the Docker image to use for this build project.
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until
	// timing out any related build that does not get marked as completed. The default
	// is 60 minutes.
	TimeoutInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s BuildConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuildConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BuildConfiguration"}

	if s.CodeBuildServiceRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("CodeBuildServiceRole"))
	}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The builder used to build the custom platform.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Builder
type Builder struct {
	_ struct{} `type:"structure"`

	// The ARN of the builder.
	ARN *string `type:"string"`
}

// String returns the string representation
func (s Builder) String() string {
	return awsutil.Prettify(s)
}

// CPU utilization metrics for an instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CPUUtilization
type CPUUtilization struct {
	_ struct{} `type:"structure"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the I/O Wait state over the
	// last 10 seconds.
	IOWait *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the IRQ state over the last
	// 10 seconds.
	IRQ *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the Idle state over the last
	// 10 seconds.
	Idle *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the Nice state over the last
	// 10 seconds.
	Nice *float64 `type:"double"`

	// Available on Windows environments only.
	//
	// Percentage of time that the CPU has spent in the Privileged state over the
	// last 10 seconds.
	Privileged *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the SoftIRQ state over the last
	// 10 seconds.
	SoftIRQ *float64 `type:"double"`

	// Available on Linux environments only.
	//
	// Percentage of time that the CPU has spent in the System state over the last
	// 10 seconds.
	System *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the User state over the last
	// 10 seconds.
	User *float64 `type:"double"`
}

// String returns the string representation
func (s CPUUtilization) String() string {
	return awsutil.Prettify(s)
}

// Describes the possible values for a configuration option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ConfigurationOptionDescription
type ConfigurationOptionDescription struct {
	_ struct{} `type:"structure"`

	// An indication of which action is required if the value for this configuration
	// option changes:
	//
	//    * NoInterruption : There is no interruption to the environment or application
	//    availability.
	//
	//    * RestartEnvironment : The environment is entirely restarted, all AWS
	//    resources are deleted and recreated, and the environment is unavailable
	//    during the process.
	//
	//    * RestartApplicationServer : The environment is available the entire time.
	//    However, a short application outage occurs when the application servers
	//    on the running Amazon EC2 instances are restarted.
	ChangeSeverity *string `type:"string"`

	// The default value for this configuration option.
	DefaultValue *string `type:"string"`

	// If specified, the configuration option must be a string value no longer than
	// this value.
	MaxLength *int64 `type:"integer"`

	// If specified, the configuration option must be a numeric value less than
	// this value.
	MaxValue *int64 `type:"integer"`

	// If specified, the configuration option must be a numeric value greater than
	// this value.
	MinValue *int64 `type:"integer"`

	// The name of the configuration option.
	Name *string `type:"string"`

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// If specified, the configuration option must be a string value that satisfies
	// this regular expression.
	Regex *OptionRestrictionRegex `type:"structure"`

	// An indication of whether the user defined this configuration option:
	//
	//    * true : This configuration option was defined by the user. It is a valid
	//    choice for specifying if this as an Option to Remove when updating configuration
	//    settings.
	//
	//    * false : This configuration was not defined by the user.
	//
	// Constraint: You can remove only UserDefined options from a configuration.
	//
	// Valid Values: true | false
	UserDefined *bool `type:"boolean"`

	// If specified, values for the configuration option are selected from this
	// list.
	ValueOptions []string `type:"list"`

	// An indication of which type of values this option has and whether it is allowable
	// to select one or more than one of the possible values:
	//
	//    * Scalar : Values for this option are a single selection from the possible
	//    values, or an unformatted string, or numeric value governed by the MIN/MAX/Regex
	//    constraints.
	//
	//    * List : Values for this option are multiple selections from the possible
	//    values.
	//
	//    * Boolean : Values for this option are either true or false .
	//
	//    * Json : Values for this option are a JSON representation of a ConfigDocument.
	ValueType ConfigurationOptionValueType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ConfigurationOptionDescription) String() string {
	return awsutil.Prettify(s)
}

// A specification identifying an individual configuration option along with
// its current value. For a list of possible option values, go to Option Values
// (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
// in the AWS Elastic Beanstalk Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ConfigurationOptionSetting
type ConfigurationOptionSetting struct {
	_ struct{} `type:"structure"`

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// The name of the configuration option.
	OptionName *string `type:"string"`

	// A unique resource name for a time-based scaling configuration option.
	ResourceName *string `min:"1" type:"string"`

	// The current value for the configuration option.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ConfigurationOptionSetting) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationOptionSetting) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigurationOptionSetting"}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the settings for a configuration set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ConfigurationSettingsDescription
type ConfigurationSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with this configuration set.
	ApplicationName *string `min:"1" type:"string"`

	// The date (in UTC time) when this configuration set was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date (in UTC time) when this configuration set was last modified.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If this configuration set is associated with an environment, the DeploymentStatus
	// parameter indicates the deployment status of this configuration set:
	//
	//    * null: This configuration is not associated with a running environment.
	//
	//    * pending: This is a draft configuration that is not deployed to the associated
	//    environment but is in the process of deploying.
	//
	//    * deployed: This is the configuration that is currently deployed to the
	//    associated running environment.
	//
	//    * failed: This is a draft configuration that failed to successfully deploy.
	DeploymentStatus ConfigurationDeploymentStatus `type:"string" enum:"true"`

	// Describes this configuration set.
	Description *string `type:"string"`

	// If not null, the name of the environment for this configuration set.
	EnvironmentName *string `min:"4" type:"string"`

	// A list of the configuration options and their values in this configuration
	// set.
	OptionSettings []ConfigurationOptionSetting `type:"list"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The name of the solution stack this configuration set uses.
	SolutionStackName *string `type:"string"`

	// If not null, the name of the configuration template for this configuration
	// set.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigurationSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// A custom AMI available to platforms.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CustomAmi
type CustomAmi struct {
	_ struct{} `type:"structure"`

	// THe ID of the image used to create the custom AMI.
	ImageId *string `type:"string"`

	// The type of virtualization used to create the custom AMI.
	VirtualizationType *string `type:"string"`
}

// String returns the string representation
func (s CustomAmi) String() string {
	return awsutil.Prettify(s)
}

// Information about an application version deployment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Deployment
type Deployment struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment. This number increases by one each time that you
	// deploy source code or change instance configuration settings.
	DeploymentId *int64 `type:"long"`

	// For in-progress deployments, the time that the deployment started.
	//
	// For completed deployments, the time that the deployment ended.
	DeploymentTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The status of the deployment:
	//
	//    * In Progress : The deployment is in progress.
	//
	//    * Deployed : The deployment succeeded.
	//
	//    * Failed : The deployment failed.
	Status *string `type:"string"`

	// The version label of the application version in the deployment.
	VersionLabel *string `type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// Describes the properties of an environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EnvironmentDescription
type EnvironmentDescription struct {
	_ struct{} `type:"structure"`

	// Indicates if there is an in-progress environment configuration update or
	// application version deployment that you can cancel.
	//
	// true: There is an update in progress.
	//
	// false: There are no updates currently in progress.
	AbortableOperationInProgress *bool `type:"boolean"`

	// The name of the application associated with this environment.
	ApplicationName *string `min:"1" type:"string"`

	// The URL to the CNAME for this environment.
	CNAME *string `min:"1" type:"string"`

	// The creation date for this environment.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The last modified date for this environment.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Describes this environment.
	Description *string `type:"string"`

	// For load-balanced, autoscaling environments, the URL to the LoadBalancer.
	// For single-instance environments, the IP address of the instance.
	EndpointURL *string `type:"string"`

	// The environment's Amazon Resource Name (ARN), which can be used in other
	// API requests that require an ARN.
	EnvironmentArn *string `type:"string"`

	// The ID of this environment.
	EnvironmentId *string `type:"string"`

	// A list of links to other environments in the same group.
	EnvironmentLinks []EnvironmentLink `type:"list"`

	// The name of this environment.
	EnvironmentName *string `min:"4" type:"string"`

	// Describes the health status of the environment. AWS Elastic Beanstalk indicates
	// the failure levels for a running environment:
	//
	//    * Red: Indicates the environment is not responsive. Occurs when three
	//    or more consecutive failures occur for an environment.
	//
	//    * Yellow: Indicates that something is wrong. Occurs when two consecutive
	//    failures occur for an environment.
	//
	//    * Green: Indicates the environment is healthy and fully functional.
	//
	//    * Grey: Default health for a new environment. The environment is not fully
	//    launched and health checks have not started or health checks are suspended
	//    during an UpdateEnvironment or RestartEnvironment request.
	//
	// Default: Grey
	Health EnvironmentHealth `type:"string" enum:"true"`

	// Returns the health status of the application running in your environment.
	// For more information, see Health Colors and Statuses (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	HealthStatus EnvironmentHealthStatus `type:"string" enum:"true"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The description of the AWS resources used by this environment.
	Resources *EnvironmentResourcesDescription `type:"structure"`

	// The name of the SolutionStack deployed with this environment.
	SolutionStackName *string `type:"string"`

	// The current operational status of the environment:
	//
	//    * Launching: Environment is in the process of initial deployment.
	//
	//    * Updating: Environment is in the process of updating its configuration
	//    settings or application version.
	//
	//    * Ready: Environment is available to have an action performed on it, such
	//    as update or terminate.
	//
	//    * Terminating: Environment is in the shut-down process.
	//
	//    * Terminated: Environment is not running.
	Status EnvironmentStatus `type:"string" enum:"true"`

	// The name of the configuration template used to originally launch this environment.
	TemplateName *string `min:"1" type:"string"`

	// Describes the current tier of this environment.
	Tier *EnvironmentTier `type:"structure"`

	// The application version deployed in this environment.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnvironmentDescription) String() string {
	return awsutil.Prettify(s)
}

// The information retrieved from the Amazon EC2 instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EnvironmentInfoDescription
type EnvironmentInfoDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 Instance ID for this information.
	Ec2InstanceId *string `type:"string"`

	// The type of information retrieved.
	InfoType EnvironmentInfoType `type:"string" enum:"true"`

	// The retrieved information. Currently contains a presigned Amazon S3 URL.
	// The files are deleted after 15 minutes.
	//
	// Anyone in possession of this URL can access the files before they are deleted.
	// Make the URL available only to trusted parties.
	Message *string `type:"string"`

	// The time stamp when this information was retrieved.
	SampleTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s EnvironmentInfoDescription) String() string {
	return awsutil.Prettify(s)
}

// A link to another environment, defined in the environment's manifest. Links
// provide connection information in system properties that can be used to connect
// to another environment in the same group. See Environment Manifest (env.yaml)
// (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
// for details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EnvironmentLink
type EnvironmentLink struct {
	_ struct{} `type:"structure"`

	// The name of the linked environment (the dependency).
	EnvironmentName *string `type:"string"`

	// The name of the link.
	LinkName *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentLink) String() string {
	return awsutil.Prettify(s)
}

// Describes the AWS resources in use by this environment. This data is live.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EnvironmentResourceDescription
type EnvironmentResourceDescription struct {
	_ struct{} `type:"structure"`

	// The AutoScalingGroups used by this environment.
	AutoScalingGroups []AutoScalingGroup `type:"list"`

	// The name of the environment.
	EnvironmentName *string `min:"4" type:"string"`

	// The Amazon EC2 instances used by this environment.
	Instances []Instance `type:"list"`

	// The Auto Scaling launch configurations in use by this environment.
	LaunchConfigurations []LaunchConfiguration `type:"list"`

	// The Amazon EC2 launch templates in use by this environment.
	LaunchTemplates []LaunchTemplate `type:"list"`

	// The LoadBalancers in use by this environment.
	LoadBalancers []LoadBalancer `type:"list"`

	// The queues used by this environment.
	Queues []Queue `type:"list"`

	// The AutoScaling triggers in use by this environment.
	Triggers []Trigger `type:"list"`
}

// String returns the string representation
func (s EnvironmentResourceDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes the AWS resources in use by this environment. This data is not
// live data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EnvironmentResourcesDescription
type EnvironmentResourcesDescription struct {
	_ struct{} `type:"structure"`

	// Describes the LoadBalancer.
	LoadBalancer *LoadBalancerDescription `type:"structure"`
}

// String returns the string representation
func (s EnvironmentResourcesDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes the properties of an environment tier
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EnvironmentTier
type EnvironmentTier struct {
	_ struct{} `type:"structure"`

	// The name of this environment tier.
	//
	// Valid values:
	//
	//    * For Web server tier – WebServer
	//
	//    * For Worker tier – Worker
	Name *string `type:"string"`

	// The type of this environment tier.
	//
	// Valid values:
	//
	//    * For Web server tier – Standard
	//
	//    * For Worker tier – SQS/HTTP
	Type *string `type:"string"`

	// The version of this environment tier. When you don't set a value to it, Elastic
	// Beanstalk uses the latest compatible worker tier version.
	//
	// This member is deprecated. Any specific version that you set may become out
	// of date. We recommend leaving it unspecified.
	Version *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentTier) String() string {
	return awsutil.Prettify(s)
}

// Describes an event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/EventDescription
type EventDescription struct {
	_ struct{} `type:"structure"`

	// The application associated with the event.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the environment associated with this event.
	EnvironmentName *string `min:"4" type:"string"`

	// The date when the event occurred.
	EventDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The event message.
	Message *string `type:"string"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The web service request ID for the activity of this event.
	RequestId *string `type:"string"`

	// The severity level of this event.
	Severity EventSeverity `type:"string" enum:"true"`

	// The name of the configuration associated with this event.
	TemplateName *string `min:"1" type:"string"`

	// The release label for the application version associated with this event.
	VersionLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EventDescription) String() string {
	return awsutil.Prettify(s)
}

// The description of an Amazon EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon EC2 instance.
	Id *string `type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// Represents summary information about the health of an instance. For more
// information, see Health Colors and Statuses (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/InstanceHealthSummary
type InstanceHealthSummary struct {
	_ struct{} `type:"structure"`

	// Red. The health agent is reporting a high number of request failures or other
	// issues for an instance or environment.
	Degraded *int64 `type:"integer"`

	// Green. An operation is in progress on an instance.
	Info *int64 `type:"integer"`

	// Grey. AWS Elastic Beanstalk and the health agent are reporting no data on
	// an instance.
	NoData *int64 `type:"integer"`

	// Green. An instance is passing health checks and the health agent is not reporting
	// any problems.
	Ok *int64 `type:"integer"`

	// Grey. An operation is in progress on an instance within the command timeout.
	Pending *int64 `type:"integer"`

	// Red. The health agent is reporting a very high number of request failures
	// or other issues for an instance or environment.
	Severe *int64 `type:"integer"`

	// Grey. AWS Elastic Beanstalk and the health agent are reporting an insufficient
	// amount of data on an instance.
	Unknown *int64 `type:"integer"`

	// Yellow. The health agent is reporting a moderate number of request failures
	// or other issues for an instance or environment.
	Warning *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceHealthSummary) String() string {
	return awsutil.Prettify(s)
}

// Represents the average latency for the slowest X percent of requests over
// the last 10 seconds.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Latency
type Latency struct {
	_ struct{} `type:"structure"`

	// The average latency for the slowest 90 percent of requests over the last
	// 10 seconds.
	P10 *float64 `type:"double"`

	// The average latency for the slowest 50 percent of requests over the last
	// 10 seconds.
	P50 *float64 `type:"double"`

	// The average latency for the slowest 25 percent of requests over the last
	// 10 seconds.
	P75 *float64 `type:"double"`

	// The average latency for the slowest 15 percent of requests over the last
	// 10 seconds.
	P85 *float64 `type:"double"`

	// The average latency for the slowest 10 percent of requests over the last
	// 10 seconds.
	P90 *float64 `type:"double"`

	// The average latency for the slowest 5 percent of requests over the last 10
	// seconds.
	P95 *float64 `type:"double"`

	// The average latency for the slowest 1 percent of requests over the last 10
	// seconds.
	P99 *float64 `type:"double"`

	// The average latency for the slowest 0.1 percent of requests over the last
	// 10 seconds.
	P999 *float64 `type:"double"`
}

// String returns the string representation
func (s Latency) String() string {
	return awsutil.Prettify(s)
}

// Describes an Auto Scaling launch configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/LaunchConfiguration
type LaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the launch configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes an Amazon EC2 launch template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/LaunchTemplate
type LaunchTemplate struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	Id *string `type:"string"`
}

// String returns the string representation
func (s LaunchTemplate) String() string {
	return awsutil.Prettify(s)
}

// Describes the properties of a Listener for the LoadBalancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Listener
type Listener struct {
	_ struct{} `type:"structure"`

	// The port that is used by the Listener.
	Port *int64 `type:"integer"`

	// The protocol that is used by the Listener.
	Protocol *string `type:"string"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// Describes a LoadBalancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/LoadBalancer
type LoadBalancer struct {
	_ struct{} `type:"structure"`

	// The name of the LoadBalancer.
	Name *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// Describes the details of a LoadBalancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/LoadBalancerDescription
type LoadBalancerDescription struct {
	_ struct{} `type:"structure"`

	// The domain name of the LoadBalancer.
	Domain *string `type:"string"`

	// A list of Listeners used by the LoadBalancer.
	Listeners []Listener `type:"list"`

	// The name of the LoadBalancer.
	LoadBalancerName *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerDescription) String() string {
	return awsutil.Prettify(s)
}

// The record of an upcoming or in-progress managed action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ManagedAction
type ManagedAction struct {
	_ struct{} `type:"structure"`

	// A description of the managed action.
	ActionDescription *string `type:"string"`

	// A unique identifier for the managed action.
	ActionId *string `type:"string"`

	// The type of managed action.
	ActionType ActionType `type:"string" enum:"true"`

	// The status of the managed action. If the action is Scheduled, you can apply
	// it immediately with ApplyEnvironmentManagedAction.
	Status ActionStatus `type:"string" enum:"true"`

	// The start time of the maintenance window in which the managed action will
	// execute.
	WindowStartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ManagedAction) String() string {
	return awsutil.Prettify(s)
}

// The record of a completed or failed managed action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ManagedActionHistoryItem
type ManagedActionHistoryItem struct {
	_ struct{} `type:"structure"`

	// A description of the managed action.
	ActionDescription *string `type:"string"`

	// A unique identifier for the managed action.
	ActionId *string `type:"string"`

	// The type of the managed action.
	ActionType ActionType `type:"string" enum:"true"`

	// The date and time that the action started executing.
	ExecutedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If the action failed, a description of the failure.
	FailureDescription *string `type:"string"`

	// If the action failed, the type of failure.
	FailureType FailureType `type:"string" enum:"true"`

	// The date and time that the action finished executing.
	FinishedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The status of the action.
	Status ActionHistoryStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ManagedActionHistoryItem) String() string {
	return awsutil.Prettify(s)
}

// A lifecycle rule that deletes application versions after the specified number
// of days.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/MaxAgeRule
type MaxAgeRule struct {
	_ struct{} `type:"structure"`

	// Set to true to delete a version's source bundle from Amazon S3 when Elastic
	// Beanstalk deletes the application version.
	DeleteSourceFromS3 *bool `type:"boolean"`

	// Specify true to apply the rule, or false to disable it.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specify the number of days to retain an application versions.
	MaxAgeInDays *int64 `type:"integer"`
}

// String returns the string representation
func (s MaxAgeRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaxAgeRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaxAgeRule"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A lifecycle rule that deletes the oldest application version when the maximum
// count is exceeded.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/MaxCountRule
type MaxCountRule struct {
	_ struct{} `type:"structure"`

	// Set to true to delete a version's source bundle from Amazon S3 when Elastic
	// Beanstalk deletes the application version.
	DeleteSourceFromS3 *bool `type:"boolean"`

	// Specify true to apply the rule, or false to disable it.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specify the maximum number of application versions to retain.
	MaxCount *int64 `type:"integer"`
}

// String returns the string representation
func (s MaxCountRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaxCountRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MaxCountRule"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A regular expression representing a restriction on a string configuration
// option value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/OptionRestrictionRegex
type OptionRestrictionRegex struct {
	_ struct{} `type:"structure"`

	// A unique name representing this regular expression.
	Label *string `type:"string"`

	// The regular expression pattern that a string configuration option value with
	// this restriction must match.
	Pattern *string `type:"string"`
}

// String returns the string representation
func (s OptionRestrictionRegex) String() string {
	return awsutil.Prettify(s)
}

// A specification identifying an individual configuration option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/OptionSpecification
type OptionSpecification struct {
	_ struct{} `type:"structure"`

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// The name of the configuration option.
	OptionName *string `type:"string"`

	// A unique resource name for a time-based scaling configuration option.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OptionSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptionSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OptionSpecification"}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Detailed information about a platform.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/PlatformDescription
type PlatformDescription struct {
	_ struct{} `type:"structure"`

	// The custom AMIs supported by the platform.
	CustomAmiList []CustomAmi `type:"list"`

	// The date when the platform was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date when the platform was last updated.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the platform.
	Description *string `type:"string"`

	// The frameworks supported by the platform.
	Frameworks []PlatformFramework `type:"list"`

	// Information about the maintainer of the platform.
	Maintainer *string `type:"string"`

	// The operating system used by the platform.
	OperatingSystemName *string `type:"string"`

	// The version of the operating system used by the platform.
	OperatingSystemVersion *string `type:"string"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The category of the platform.
	PlatformCategory *string `type:"string"`

	// The name of the platform.
	PlatformName *string `type:"string"`

	// The AWS account ID of the person who created the platform.
	PlatformOwner *string `type:"string"`

	// The status of the platform.
	PlatformStatus PlatformStatus `type:"string" enum:"true"`

	// The version of the platform.
	PlatformVersion *string `type:"string"`

	// The programming languages supported by the platform.
	ProgrammingLanguages []PlatformProgrammingLanguage `type:"list"`

	// The name of the solution stack used by the platform.
	SolutionStackName *string `type:"string"`

	// The additions supported by the platform.
	SupportedAddonList []string `type:"list"`

	// The tiers supported by the platform.
	SupportedTierList []string `type:"list"`
}

// String returns the string representation
func (s PlatformDescription) String() string {
	return awsutil.Prettify(s)
}

// Specify criteria to restrict the results when listing custom platforms.
//
// The filter is evaluated as the expression:
//
// Type Operator Values[i]
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/PlatformFilter
type PlatformFilter struct {
	_ struct{} `type:"structure"`

	// The operator to apply to the Type with each of the Values.
	//
	// Valid Values: = (equal to) | != (not equal to) | < (less than) | <= (less
	// than or equal to) | > (greater than) | >= (greater than or equal to) | contains
	// | begins_with | ends_with
	Operator *string `type:"string"`

	// The custom platform attribute to which the filter values are applied.
	//
	// Valid Values: PlatformName | PlatformVersion | PlatformStatus | PlatformOwner
	Type *string `type:"string"`

	// The list of values applied to the custom platform attribute.
	Values []string `type:"list"`
}

// String returns the string representation
func (s PlatformFilter) String() string {
	return awsutil.Prettify(s)
}

// A framework supported by the custom platform.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/PlatformFramework
type PlatformFramework struct {
	_ struct{} `type:"structure"`

	// The name of the framework.
	Name *string `type:"string"`

	// The version of the framework.
	Version *string `type:"string"`
}

// String returns the string representation
func (s PlatformFramework) String() string {
	return awsutil.Prettify(s)
}

// A programming language supported by the platform.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/PlatformProgrammingLanguage
type PlatformProgrammingLanguage struct {
	_ struct{} `type:"structure"`

	// The name of the programming language.
	Name *string `type:"string"`

	// The version of the programming language.
	Version *string `type:"string"`
}

// String returns the string representation
func (s PlatformProgrammingLanguage) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a platform.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/PlatformSummary
type PlatformSummary struct {
	_ struct{} `type:"structure"`

	// The operating system used by the platform.
	OperatingSystemName *string `type:"string"`

	// The version of the operating system used by the platform.
	OperatingSystemVersion *string `type:"string"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The category of platform.
	PlatformCategory *string `type:"string"`

	// The AWS account ID of the person who created the platform.
	PlatformOwner *string `type:"string"`

	// The status of the platform. You can create an environment from the platform
	// once it is ready.
	PlatformStatus PlatformStatus `type:"string" enum:"true"`

	// The additions associated with the platform.
	SupportedAddonList []string `type:"list"`

	// The tiers in which the platform runs.
	SupportedTierList []string `type:"list"`
}

// String returns the string representation
func (s PlatformSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes a queue.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Queue
type Queue struct {
	_ struct{} `type:"structure"`

	// The name of the queue.
	Name *string `type:"string"`

	// The URL of the queue.
	URL *string `type:"string"`
}

// String returns the string representation
func (s Queue) String() string {
	return awsutil.Prettify(s)
}

// The AWS Elastic Beanstalk quota information for a single resource type in
// an AWS account. It reflects the resource's limits for this account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ResourceQuota
type ResourceQuota struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances of this Elastic Beanstalk resource type that
	// an AWS account can use.
	Maximum *int64 `type:"integer"`
}

// String returns the string representation
func (s ResourceQuota) String() string {
	return awsutil.Prettify(s)
}

// A set of per-resource AWS Elastic Beanstalk quotas associated with an AWS
// account. They reflect Elastic Beanstalk resource limits for this account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ResourceQuotas
type ResourceQuotas struct {
	_ struct{} `type:"structure"`

	// The quota for applications in the AWS account.
	ApplicationQuota *ResourceQuota `type:"structure"`

	// The quota for application versions in the AWS account.
	ApplicationVersionQuota *ResourceQuota `type:"structure"`

	// The quota for configuration templates in the AWS account.
	ConfigurationTemplateQuota *ResourceQuota `type:"structure"`

	// The quota for custom platforms in the AWS account.
	CustomPlatformQuota *ResourceQuota `type:"structure"`

	// The quota for environments in the AWS account.
	EnvironmentQuota *ResourceQuota `type:"structure"`
}

// String returns the string representation
func (s ResourceQuotas) String() string {
	return awsutil.Prettify(s)
}

// The bucket and key of an item stored in Amazon S3.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/S3Location
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the data is located.
	S3Bucket *string `type:"string"`

	// The Amazon S3 key where the data is located.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Detailed health information about an Amazon EC2 instance in your Elastic
// Beanstalk environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SingleInstanceHealth
type SingleInstanceHealth struct {
	_ struct{} `type:"structure"`

	// Request metrics from your application.
	ApplicationMetrics *ApplicationMetrics `type:"structure"`

	// The availability zone in which the instance runs.
	AvailabilityZone *string `type:"string"`

	// Represents the causes, which provide more information about the current health
	// status.
	Causes []string `type:"list"`

	// Represents the color indicator that gives you information about the health
	// of the EC2 instance. For more information, see Health Colors and Statuses
	// (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	Color *string `type:"string"`

	// Information about the most recent deployment to an instance.
	Deployment *Deployment `type:"structure"`

	// Returns the health status of the specified instance. For more information,
	// see Health Colors and Statuses (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	HealthStatus *string `type:"string"`

	// The ID of the Amazon EC2 instance.
	InstanceId *string `min:"1" type:"string"`

	// The instance's type.
	InstanceType *string `type:"string"`

	// The time at which the EC2 instance was launched.
	LaunchedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Operating system metrics from the instance.
	System *SystemStatus `type:"structure"`
}

// String returns the string representation
func (s SingleInstanceHealth) String() string {
	return awsutil.Prettify(s)
}

// Describes the solution stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SolutionStackDescription
type SolutionStackDescription struct {
	_ struct{} `type:"structure"`

	// The permitted file types allowed for a solution stack.
	PermittedFileTypes []string `type:"list"`

	// The name of the solution stack.
	SolutionStackName *string `type:"string"`
}

// String returns the string representation
func (s SolutionStackDescription) String() string {
	return awsutil.Prettify(s)
}

// Location of the source code for an application version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SourceBuildInformation
type SourceBuildInformation struct {
	_ struct{} `type:"structure"`

	// The location of the source code, as a formatted string, depending on the
	// value of SourceRepository
	//
	//    * For CodeCommit, the format is the repository name and commit ID, separated
	//    by a forward slash. For example, my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a.
	//
	//    * For S3, the format is the S3 bucket name and object key, separated by
	//    a forward slash. For example, my-s3-bucket/Folders/my-source-file.
	//
	// SourceLocation is a required field
	SourceLocation *string `min:"3" type:"string" required:"true"`

	// Location where the repository is stored.
	//
	//    * CodeCommit
	//
	//    * S3
	//
	// SourceRepository is a required field
	SourceRepository SourceRepository `type:"string" required:"true" enum:"true"`

	// The type of repository.
	//
	//    * Git
	//
	//    * Zip
	//
	// SourceType is a required field
	SourceType SourceType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SourceBuildInformation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceBuildInformation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceBuildInformation"}

	if s.SourceLocation == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceLocation"))
	}
	if s.SourceLocation != nil && len(*s.SourceLocation) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceLocation", 3))
	}
	if len(s.SourceRepository) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SourceRepository"))
	}
	if len(s.SourceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A specification for an environment configuration
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SourceConfiguration
type SourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with the configuration.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the configuration template.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceConfiguration"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the percentage of requests over the last 10 seconds that resulted
// in each type of status code response. For more information, see Status Code
// Definitions (http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/StatusCodes
type StatusCodes struct {
	_ struct{} `type:"structure"`

	// The percentage of requests over the last 10 seconds that resulted in a 2xx
	// (200, 201, etc.) status code.
	Status2xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 3xx
	// (300, 301, etc.) status code.
	Status3xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 4xx
	// (400, 401, etc.) status code.
	Status4xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 5xx
	// (500, 501, etc.) status code.
	Status5xx *int64 `type:"integer"`
}

// String returns the string representation
func (s StatusCodes) String() string {
	return awsutil.Prettify(s)
}

// CPU utilization and load average metrics for an Amazon EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SystemStatus
type SystemStatus struct {
	_ struct{} `type:"structure"`

	// CPU utilization metrics for the instance.
	CPUUtilization *CPUUtilization `type:"structure"`

	// Load average in the last 1-minute, 5-minute, and 15-minute periods. For more
	// information, see Operating System Metrics (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-metrics.html#health-enhanced-metrics-os).
	LoadAverage []float64 `type:"list"`
}

// String returns the string representation
func (s SystemStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes a tag applied to a resource in an environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	Key *string `min:"1" type:"string"`

	// The value of the tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a trigger.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Trigger
type Trigger struct {
	_ struct{} `type:"structure"`

	// The name of the trigger.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Trigger) String() string {
	return awsutil.Prettify(s)
}

// An error or warning for a desired configuration option value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidationMessage
type ValidationMessage struct {
	_ struct{} `type:"structure"`

	// A message describing the error or warning.
	Message *string `type:"string"`

	// The namespace to which the option belongs.
	Namespace *string `type:"string"`

	// The name of the option.
	OptionName *string `type:"string"`

	// An indication of the severity of this message:
	//
	//    * error: This message indicates that this is not a valid setting for an
	//    option.
	//
	//    * warning: This message is providing information you should take into
	//    account.
	Severity ValidationSeverity `type:"string" enum:"true"`
}

// String returns the string representation
func (s ValidationMessage) String() string {
	return awsutil.Prettify(s)
}
