// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRuleInput
type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	//
	// RuleArn is a required field
	RuleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRuleInput"}

	if s.RuleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRuleOutput
type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Deletes the specified rule.
//
//    // Example sending a request using DeleteRuleRequest.
//    req := client.DeleteRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule
func (c *Client) DeleteRuleRequest(input *DeleteRuleInput) DeleteRuleRequest {
	op := &aws.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	req := c.newRequest(op, input, &DeleteRuleOutput{})
	return DeleteRuleRequest{Request: req, Input: input, Copy: c.DeleteRuleRequest}
}

// DeleteRuleRequest is the request type for the
// DeleteRule API operation.
type DeleteRuleRequest struct {
	*aws.Request
	Input *DeleteRuleInput
	Copy  func(*DeleteRuleInput) DeleteRuleRequest
}

// Send marshals and sends the DeleteRule API request.
func (r DeleteRuleRequest) Send(ctx context.Context) (*DeleteRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRuleResponse{
		DeleteRuleOutput: r.Request.Data.(*DeleteRuleOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRuleResponse is the response type for the
// DeleteRule API operation.
type DeleteRuleResponse struct {
	*DeleteRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRule request.
func (r *DeleteRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
