// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The ListJobsByStatusRequest structure.
type ListJobsByStatusInput struct {
	_ struct{} `type:"structure"`

	// To list jobs in chronological order by the date and time that they were submitted,
	// enter true. To list jobs in reverse chronological order, enter false.
	Ascending *string `location:"querystring" locationName:"Ascending" type:"string"`

	// When Elastic Transcoder returns more than one page of results, use pageToken
	// in subsequent GET requests to get each successive page of results.
	PageToken *string `location:"querystring" locationName:"PageToken" type:"string"`

	// To get information about all of the jobs associated with the current AWS
	// account that have a given status, specify the following status: Submitted,
	// Progressing, Complete, Canceled, or Error.
	//
	// Status is a required field
	Status *string `location:"uri" locationName:"Status" type:"string" required:"true"`
}

// String returns the string representation
func (s ListJobsByStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsByStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListJobsByStatusInput"}

	if s.Status == nil {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJobsByStatusInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ascending != nil {
		v := *s.Ascending

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Ascending", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageToken != nil {
		v := *s.PageToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "PageToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The ListJobsByStatusResponse structure.
type ListJobsByStatusOutput struct {
	_ struct{} `type:"structure"`

	// An array of Job objects that have the specified status.
	Jobs []Job `type:"list"`

	// A value that you use to access the second and subsequent pages of results,
	// if any. When the jobs in the specified pipeline fit on one page or when you've
	// reached the last page of results, the value of NextPageToken is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListJobsByStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListJobsByStatusOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Jobs) > 0 {
		v := s.Jobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Jobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextPageToken != nil {
		v := *s.NextPageToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextPageToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListJobsByStatus = "ListJobsByStatus"

// ListJobsByStatusRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The ListJobsByStatus operation gets a list of jobs that have a specified
// status. The response body contains one element for each job that satisfies
// the search criteria.
//
//    // Example sending a request using ListJobsByStatusRequest.
//    req := client.ListJobsByStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListJobsByStatusRequest(input *ListJobsByStatusInput) ListJobsByStatusRequest {
	op := &aws.Operation{
		Name:       opListJobsByStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/jobsByStatus/{Status}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsByStatusInput{}
	}

	req := c.newRequest(op, input, &ListJobsByStatusOutput{})
	return ListJobsByStatusRequest{Request: req, Input: input, Copy: c.ListJobsByStatusRequest}
}

// ListJobsByStatusRequest is the request type for the
// ListJobsByStatus API operation.
type ListJobsByStatusRequest struct {
	*aws.Request
	Input *ListJobsByStatusInput
	Copy  func(*ListJobsByStatusInput) ListJobsByStatusRequest
}

// Send marshals and sends the ListJobsByStatus API request.
func (r ListJobsByStatusRequest) Send(ctx context.Context) (*ListJobsByStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListJobsByStatusResponse{
		ListJobsByStatusOutput: r.Request.Data.(*ListJobsByStatusOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListJobsByStatusRequestPaginator returns a paginator for ListJobsByStatus.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListJobsByStatusRequest(input)
//   p := elastictranscoder.NewListJobsByStatusRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListJobsByStatusPaginator(req ListJobsByStatusRequest) ListJobsByStatusPaginator {
	return ListJobsByStatusPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListJobsByStatusInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListJobsByStatusPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListJobsByStatusPaginator struct {
	aws.Pager
}

func (p *ListJobsByStatusPaginator) CurrentPage() *ListJobsByStatusOutput {
	return p.Pager.CurrentPage().(*ListJobsByStatusOutput)
}

// ListJobsByStatusResponse is the response type for the
// ListJobsByStatus API operation.
type ListJobsByStatusResponse struct {
	*ListJobsByStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListJobsByStatus request.
func (r *ListJobsByStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
