// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueueInput
type DeleteGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGameSessionQueueInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteGameSessionQueueInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueueOutput
type DeleteGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteGameSessionQueue = "DeleteGameSessionQueue"

// DeleteGameSessionQueueRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Deletes a game session queue. This action means that any StartGameSessionPlacement
// requests that reference this queue will fail. To delete a queue, specify
// the queue name.
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
//    // Example sending a request using DeleteGameSessionQueueRequest.
//    req := client.DeleteGameSessionQueueRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue
func (c *Client) DeleteGameSessionQueueRequest(input *DeleteGameSessionQueueInput) DeleteGameSessionQueueRequest {
	op := &aws.Operation{
		Name:       opDeleteGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGameSessionQueueInput{}
	}

	req := c.newRequest(op, input, &DeleteGameSessionQueueOutput{})
	return DeleteGameSessionQueueRequest{Request: req, Input: input, Copy: c.DeleteGameSessionQueueRequest}
}

// DeleteGameSessionQueueRequest is the request type for the
// DeleteGameSessionQueue API operation.
type DeleteGameSessionQueueRequest struct {
	*aws.Request
	Input *DeleteGameSessionQueueInput
	Copy  func(*DeleteGameSessionQueueInput) DeleteGameSessionQueueRequest
}

// Send marshals and sends the DeleteGameSessionQueue API request.
func (r DeleteGameSessionQueueRequest) Send(ctx context.Context) (*DeleteGameSessionQueueResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteGameSessionQueueResponse{
		DeleteGameSessionQueueOutput: r.Request.Data.(*DeleteGameSessionQueueOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteGameSessionQueueResponse is the response type for the
// DeleteGameSessionQueue API operation.
type DeleteGameSessionQueueResponse struct {
	*DeleteGameSessionQueueOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteGameSessionQueue request.
func (r *DeleteGameSessionQueueResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
