// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacementInput
type DescribeGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session placement to retrieve.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionPlacementInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeGameSessionPlacementInput"}

	if s.PlacementId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlacementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacementOutput
type DescribeGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the requested game session placement.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation
func (s DescribeGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeGameSessionPlacement = "DescribeGameSessionPlacement"

// DescribeGameSessionPlacementRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves properties and current status of a game session placement request.
// To get game session placement details, specify the placement ID. If successful,
// a GameSessionPlacement object is returned.
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements StartGameSessionPlacement DescribeGameSessionPlacement
//    StopGameSessionPlacement
//
//    // Example sending a request using DescribeGameSessionPlacementRequest.
//    req := client.DescribeGameSessionPlacementRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement
func (c *Client) DescribeGameSessionPlacementRequest(input *DescribeGameSessionPlacementInput) DescribeGameSessionPlacementRequest {
	op := &aws.Operation{
		Name:       opDescribeGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionPlacementInput{}
	}

	req := c.newRequest(op, input, &DescribeGameSessionPlacementOutput{})
	return DescribeGameSessionPlacementRequest{Request: req, Input: input, Copy: c.DescribeGameSessionPlacementRequest}
}

// DescribeGameSessionPlacementRequest is the request type for the
// DescribeGameSessionPlacement API operation.
type DescribeGameSessionPlacementRequest struct {
	*aws.Request
	Input *DescribeGameSessionPlacementInput
	Copy  func(*DescribeGameSessionPlacementInput) DescribeGameSessionPlacementRequest
}

// Send marshals and sends the DescribeGameSessionPlacement API request.
func (r DescribeGameSessionPlacementRequest) Send(ctx context.Context) (*DescribeGameSessionPlacementResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGameSessionPlacementResponse{
		DescribeGameSessionPlacementOutput: r.Request.Data.(*DescribeGameSessionPlacementOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeGameSessionPlacementResponse is the response type for the
// DescribeGameSessionPlacement API operation.
type DescribeGameSessionPlacementResponse struct {
	*DescribeGameSessionPlacementOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGameSessionPlacement request.
func (r *DescribeGameSessionPlacementResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
