// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Input for GetVaultAccessPolicy.
type GetVaultAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVaultAccessPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVaultAccessPolicyInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVaultAccessPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Output for GetVaultAccessPolicy.
type GetVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// Contains the returned vault access policy as a JSON string.
	Policy *VaultAccessPolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation
func (s GetVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVaultAccessPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := s.Policy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "policy", v, metadata)
	}
	return nil
}

const opGetVaultAccessPolicy = "GetVaultAccessPolicy"

// GetVaultAccessPolicyRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation retrieves the access-policy subresource set on the vault;
// for more information on setting this subresource, see Set Vault Access Policy
// (PUT access-policy) (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html).
// If there is no access policy set on the vault, the operation returns a 404
// Not found error. For more information about vault access policies, see Amazon
// Glacier Access Control with Vault Access Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
//
//    // Example sending a request using GetVaultAccessPolicyRequest.
//    req := client.GetVaultAccessPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetVaultAccessPolicyRequest(input *GetVaultAccessPolicyInput) GetVaultAccessPolicyRequest {
	op := &aws.Operation{
		Name:       opGetVaultAccessPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/access-policy",
	}

	if input == nil {
		input = &GetVaultAccessPolicyInput{}
	}

	req := c.newRequest(op, input, &GetVaultAccessPolicyOutput{})
	return GetVaultAccessPolicyRequest{Request: req, Input: input, Copy: c.GetVaultAccessPolicyRequest}
}

// GetVaultAccessPolicyRequest is the request type for the
// GetVaultAccessPolicy API operation.
type GetVaultAccessPolicyRequest struct {
	*aws.Request
	Input *GetVaultAccessPolicyInput
	Copy  func(*GetVaultAccessPolicyInput) GetVaultAccessPolicyRequest
}

// Send marshals and sends the GetVaultAccessPolicy API request.
func (r GetVaultAccessPolicyRequest) Send(ctx context.Context) (*GetVaultAccessPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVaultAccessPolicyResponse{
		GetVaultAccessPolicyOutput: r.Request.Data.(*GetVaultAccessPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVaultAccessPolicyResponse is the response type for the
// GetVaultAccessPolicy API operation.
type GetVaultAccessPolicyResponse struct {
	*GetVaultAccessPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVaultAccessPolicy request.
func (r *GetVaultAccessPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
