// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package globalaccelerator

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroupsRequest
type ListEndpointGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The number of endpoint group objects that you want to return with this call.
	// The default value is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListEndpointGroupsInput"}

	if s.ListenerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListenerArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroupsResponse
type ListEndpointGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the endpoint groups associated with a listener.
	EndpointGroups []EndpointGroup `type:"list"`

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListEndpointGroups = "ListEndpointGroups"

// ListEndpointGroupsRequest returns a request value for making API operation for
// AWS Global Accelerator.
//
// List the endpoint groups that are associated with a listener.
//
//    // Example sending a request using ListEndpointGroupsRequest.
//    req := client.ListEndpointGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups
func (c *Client) ListEndpointGroupsRequest(input *ListEndpointGroupsInput) ListEndpointGroupsRequest {
	op := &aws.Operation{
		Name:       opListEndpointGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEndpointGroupsInput{}
	}

	req := c.newRequest(op, input, &ListEndpointGroupsOutput{})
	return ListEndpointGroupsRequest{Request: req, Input: input, Copy: c.ListEndpointGroupsRequest}
}

// ListEndpointGroupsRequest is the request type for the
// ListEndpointGroups API operation.
type ListEndpointGroupsRequest struct {
	*aws.Request
	Input *ListEndpointGroupsInput
	Copy  func(*ListEndpointGroupsInput) ListEndpointGroupsRequest
}

// Send marshals and sends the ListEndpointGroups API request.
func (r ListEndpointGroupsRequest) Send(ctx context.Context) (*ListEndpointGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListEndpointGroupsResponse{
		ListEndpointGroupsOutput: r.Request.Data.(*ListEndpointGroupsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListEndpointGroupsResponse is the response type for the
// ListEndpointGroups API operation.
type ListEndpointGroupsResponse struct {
	*ListEndpointGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListEndpointGroups request.
func (r *ListEndpointGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
