// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunctionRequest
type CreateUserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the function. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which to create the function.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A FunctionInput object that defines the function to create in the Data Catalog.
	//
	// FunctionInput is a required field
	FunctionInput *UserDefinedFunctionInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateUserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserDefinedFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateUserDefinedFunctionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.FunctionInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionInput"))
	}
	if s.FunctionInput != nil {
		if err := s.FunctionInput.Validate(); err != nil {
			invalidParams.AddNested("FunctionInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunctionResponse
type CreateUserDefinedFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateUserDefinedFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateUserDefinedFunction = "CreateUserDefinedFunction"

// CreateUserDefinedFunctionRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates a new function definition in the Data Catalog.
//
//    // Example sending a request using CreateUserDefinedFunctionRequest.
//    req := client.CreateUserDefinedFunctionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction
func (c *Client) CreateUserDefinedFunctionRequest(input *CreateUserDefinedFunctionInput) CreateUserDefinedFunctionRequest {
	op := &aws.Operation{
		Name:       opCreateUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserDefinedFunctionInput{}
	}

	req := c.newRequest(op, input, &CreateUserDefinedFunctionOutput{})
	return CreateUserDefinedFunctionRequest{Request: req, Input: input, Copy: c.CreateUserDefinedFunctionRequest}
}

// CreateUserDefinedFunctionRequest is the request type for the
// CreateUserDefinedFunction API operation.
type CreateUserDefinedFunctionRequest struct {
	*aws.Request
	Input *CreateUserDefinedFunctionInput
	Copy  func(*CreateUserDefinedFunctionInput) CreateUserDefinedFunctionRequest
}

// Send marshals and sends the CreateUserDefinedFunction API request.
func (r CreateUserDefinedFunctionRequest) Send(ctx context.Context) (*CreateUserDefinedFunctionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateUserDefinedFunctionResponse{
		CreateUserDefinedFunctionOutput: r.Request.Data.(*CreateUserDefinedFunctionOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateUserDefinedFunctionResponse is the response type for the
// CreateUserDefinedFunction API operation.
type CreateUserDefinedFunctionResponse struct {
	*CreateUserDefinedFunctionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateUserDefinedFunction request.
func (r *CreateUserDefinedFunctionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
