// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraphRequest
type GetDataflowGraphInput struct {
	_ struct{} `type:"structure"`

	// The Python script to transform.
	PythonScript *string `type:"string"`
}

// String returns the string representation
func (s GetDataflowGraphInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraphResponse
type GetDataflowGraphOutput struct {
	_ struct{} `type:"structure"`

	// A list of the edges in the resulting DAG.
	DagEdges []CodeGenEdge `type:"list"`

	// A list of the nodes in the resulting DAG.
	DagNodes []CodeGenNode `type:"list"`
}

// String returns the string representation
func (s GetDataflowGraphOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDataflowGraph = "GetDataflowGraph"

// GetDataflowGraphRequest returns a request value for making API operation for
// AWS Glue.
//
// Transforms a Python script into a directed acyclic graph (DAG).
//
//    // Example sending a request using GetDataflowGraphRequest.
//    req := client.GetDataflowGraphRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph
func (c *Client) GetDataflowGraphRequest(input *GetDataflowGraphInput) GetDataflowGraphRequest {
	op := &aws.Operation{
		Name:       opGetDataflowGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataflowGraphInput{}
	}

	req := c.newRequest(op, input, &GetDataflowGraphOutput{})
	return GetDataflowGraphRequest{Request: req, Input: input, Copy: c.GetDataflowGraphRequest}
}

// GetDataflowGraphRequest is the request type for the
// GetDataflowGraph API operation.
type GetDataflowGraphRequest struct {
	*aws.Request
	Input *GetDataflowGraphInput
	Copy  func(*GetDataflowGraphInput) GetDataflowGraphRequest
}

// Send marshals and sends the GetDataflowGraph API request.
func (r GetDataflowGraphRequest) Send(ctx context.Context) (*GetDataflowGraphResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDataflowGraphResponse{
		GetDataflowGraphOutput: r.Request.Data.(*GetDataflowGraphOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDataflowGraphResponse is the response type for the
// GetDataflowGraph API operation.
type GetDataflowGraphResponse struct {
	*GetDataflowGraphOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDataflowGraph request.
func (r *GetDataflowGraphResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
