// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSetRequest
type DeleteThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThreatIntelSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteThreatIntelSetInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if s.ThreatIntelSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThreatIntelSetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThreatIntelSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThreatIntelSetId != nil {
		v := *s.ThreatIntelSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "threatIntelSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSetResponse
type DeleteThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteThreatIntelSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteThreatIntelSet = "DeleteThreatIntelSet"

// DeleteThreatIntelSetRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Deletes ThreatIntelSet specified by the ThreatIntelSet ID.
//
//    // Example sending a request using DeleteThreatIntelSetRequest.
//    req := client.DeleteThreatIntelSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet
func (c *Client) DeleteThreatIntelSetRequest(input *DeleteThreatIntelSetInput) DeleteThreatIntelSetRequest {
	op := &aws.Operation{
		Name:       opDeleteThreatIntelSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &DeleteThreatIntelSetInput{}
	}

	req := c.newRequest(op, input, &DeleteThreatIntelSetOutput{})
	return DeleteThreatIntelSetRequest{Request: req, Input: input, Copy: c.DeleteThreatIntelSetRequest}
}

// DeleteThreatIntelSetRequest is the request type for the
// DeleteThreatIntelSet API operation.
type DeleteThreatIntelSetRequest struct {
	*aws.Request
	Input *DeleteThreatIntelSetInput
	Copy  func(*DeleteThreatIntelSetInput) DeleteThreatIntelSetRequest
}

// Send marshals and sends the DeleteThreatIntelSet API request.
func (r DeleteThreatIntelSetRequest) Send(ctx context.Context) (*DeleteThreatIntelSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteThreatIntelSetResponse{
		DeleteThreatIntelSetOutput: r.Request.Data.(*DeleteThreatIntelSetOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteThreatIntelSetResponse is the response type for the
// DeleteThreatIntelSet API operation.
type DeleteThreatIntelSetResponse struct {
	*DeleteThreatIntelSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteThreatIntelSet request.
func (r *DeleteThreatIntelSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
