// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfileRequest
type DeleteLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the user whose password you want to delete.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoginProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLoginProfileInput"}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfileOutput
type DeleteLoginProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLoginProfile = "DeleteLoginProfile"

// DeleteLoginProfileRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Deletes the password for the specified IAM user, which terminates the user's
// ability to access AWS services through the AWS Management Console.
//
// Deleting a user's password does not prevent a user from accessing AWS through
// the command line interface or the API. To prevent all user access, you must
// also either make any access keys inactive or delete them. For more information
// about making keys inactive or deleting them, see UpdateAccessKey and DeleteAccessKey.
//
//    // Example sending a request using DeleteLoginProfileRequest.
//    req := client.DeleteLoginProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile
func (c *Client) DeleteLoginProfileRequest(input *DeleteLoginProfileInput) DeleteLoginProfileRequest {
	op := &aws.Operation{
		Name:       opDeleteLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoginProfileInput{}
	}

	req := c.newRequest(op, input, &DeleteLoginProfileOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteLoginProfileRequest{Request: req, Input: input, Copy: c.DeleteLoginProfileRequest}
}

// DeleteLoginProfileRequest is the request type for the
// DeleteLoginProfile API operation.
type DeleteLoginProfileRequest struct {
	*aws.Request
	Input *DeleteLoginProfileInput
	Copy  func(*DeleteLoginProfileInput) DeleteLoginProfileRequest
}

// Send marshals and sends the DeleteLoginProfile API request.
func (r DeleteLoginProfileRequest) Send(ctx context.Context) (*DeleteLoginProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLoginProfileResponse{
		DeleteLoginProfileOutput: r.Request.Data.(*DeleteLoginProfileOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLoginProfileResponse is the response type for the
// DeleteLoginProfile API operation.
type DeleteLoginProfileResponse struct {
	*DeleteLoginProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLoginProfile request.
func (r *DeleteLoginProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
