// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPermissionsBoundaryRequest
type PutUserPermissionsBoundaryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the policy that is used to set the permissions boundary for the
	// user.
	//
	// PermissionsBoundary is a required field
	PermissionsBoundary *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the IAM user for which you want to set
	// the permissions boundary.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutUserPermissionsBoundaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutUserPermissionsBoundaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutUserPermissionsBoundaryInput"}

	if s.PermissionsBoundary == nil {
		invalidParams.Add(aws.NewErrParamRequired("PermissionsBoundary"))
	}
	if s.PermissionsBoundary != nil && len(*s.PermissionsBoundary) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PermissionsBoundary", 20))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPermissionsBoundaryOutput
type PutUserPermissionsBoundaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutUserPermissionsBoundaryOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutUserPermissionsBoundary = "PutUserPermissionsBoundary"

// PutUserPermissionsBoundaryRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Adds or updates the policy that is specified as the IAM user's permissions
// boundary. You can use an AWS managed policy or a customer managed policy
// to set the boundary for a user. Use the boundary to control the maximum permissions
// that the user can have. Setting a permissions boundary is an advanced feature
// that can affect the permissions for the user.
//
// Policies that are used as permissions boundaries do not provide permissions.
// You must also attach a permissions policy to the user. To learn how the effective
// permissions for a user are evaluated, see IAM JSON Policy Evaluation Logic
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html)
// in the IAM User Guide.
//
//    // Example sending a request using PutUserPermissionsBoundaryRequest.
//    req := client.PutUserPermissionsBoundaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPermissionsBoundary
func (c *Client) PutUserPermissionsBoundaryRequest(input *PutUserPermissionsBoundaryInput) PutUserPermissionsBoundaryRequest {
	op := &aws.Operation{
		Name:       opPutUserPermissionsBoundary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutUserPermissionsBoundaryInput{}
	}

	req := c.newRequest(op, input, &PutUserPermissionsBoundaryOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutUserPermissionsBoundaryRequest{Request: req, Input: input, Copy: c.PutUserPermissionsBoundaryRequest}
}

// PutUserPermissionsBoundaryRequest is the request type for the
// PutUserPermissionsBoundary API operation.
type PutUserPermissionsBoundaryRequest struct {
	*aws.Request
	Input *PutUserPermissionsBoundaryInput
	Copy  func(*PutUserPermissionsBoundaryInput) PutUserPermissionsBoundaryRequest
}

// Send marshals and sends the PutUserPermissionsBoundary API request.
func (r PutUserPermissionsBoundaryRequest) Send(ctx context.Context) (*PutUserPermissionsBoundaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutUserPermissionsBoundaryResponse{
		PutUserPermissionsBoundaryOutput: r.Request.Data.(*PutUserPermissionsBoundaryOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutUserPermissionsBoundaryResponse is the response type for the
// PutUserPermissionsBoundary API operation.
type PutUserPermissionsBoundaryResponse struct {
	*PutUserPermissionsBoundaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutUserPermissionsBoundary request.
func (r *PutUserPermissionsBoundaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
