// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProviderRequest
type RemoveClientIDFromOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The client ID (also known as audience) to remove from the IAM OIDC provider
	// resource. For more information about client IDs, see CreateOpenIDConnectProvider.
	//
	// ClientID is a required field
	ClientID *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM OIDC provider resource to remove
	// the client ID from. You can get a list of OIDC provider ARNs by using the
	// ListOpenIDConnectProviders operation.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// OpenIDConnectProviderArn is a required field
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveClientIDFromOpenIDConnectProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveClientIDFromOpenIDConnectProviderInput"}

	if s.ClientID == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientID"))
	}
	if s.ClientID != nil && len(*s.ClientID) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientID", 1))
	}

	if s.OpenIDConnectProviderArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("OpenIDConnectProviderArn"))
	}
	if s.OpenIDConnectProviderArn != nil && len(*s.OpenIDConnectProviderArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("OpenIDConnectProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProviderOutput
type RemoveClientIDFromOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveClientIDFromOpenIDConnectProvider = "RemoveClientIDFromOpenIDConnectProvider"

// RemoveClientIDFromOpenIDConnectProviderRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Removes the specified client ID (also known as audience) from the list of
// client IDs registered for the specified IAM OpenID Connect (OIDC) provider
// resource object.
//
// This operation is idempotent; it does not fail or return an error if you
// try to remove a client ID that does not exist.
//
//    // Example sending a request using RemoveClientIDFromOpenIDConnectProviderRequest.
//    req := client.RemoveClientIDFromOpenIDConnectProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProvider
func (c *Client) RemoveClientIDFromOpenIDConnectProviderRequest(input *RemoveClientIDFromOpenIDConnectProviderInput) RemoveClientIDFromOpenIDConnectProviderRequest {
	op := &aws.Operation{
		Name:       opRemoveClientIDFromOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveClientIDFromOpenIDConnectProviderInput{}
	}

	req := c.newRequest(op, input, &RemoveClientIDFromOpenIDConnectProviderOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RemoveClientIDFromOpenIDConnectProviderRequest{Request: req, Input: input, Copy: c.RemoveClientIDFromOpenIDConnectProviderRequest}
}

// RemoveClientIDFromOpenIDConnectProviderRequest is the request type for the
// RemoveClientIDFromOpenIDConnectProvider API operation.
type RemoveClientIDFromOpenIDConnectProviderRequest struct {
	*aws.Request
	Input *RemoveClientIDFromOpenIDConnectProviderInput
	Copy  func(*RemoveClientIDFromOpenIDConnectProviderInput) RemoveClientIDFromOpenIDConnectProviderRequest
}

// Send marshals and sends the RemoveClientIDFromOpenIDConnectProvider API request.
func (r RemoveClientIDFromOpenIDConnectProviderRequest) Send(ctx context.Context) (*RemoveClientIDFromOpenIDConnectProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveClientIDFromOpenIDConnectProviderResponse{
		RemoveClientIDFromOpenIDConnectProviderOutput: r.Request.Data.(*RemoveClientIDFromOpenIDConnectProviderOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveClientIDFromOpenIDConnectProviderResponse is the response type for the
// RemoveClientIDFromOpenIDConnectProvider API operation.
type RemoveClientIDFromOpenIDConnectProviderResponse struct {
	*RemoveClientIDFromOpenIDConnectProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveClientIDFromOpenIDConnectProvider request.
func (r *RemoveClientIDFromOpenIDConnectProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
