// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunsRequest
type ListAssessmentRunsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs that specify the assessment templates whose assessment runs you
	// want to list.
	AssessmentTemplateArns []string `locationName:"assessmentTemplateArns" type:"list"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentRunFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the ListAssessmentRuns action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssessmentRunsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssessmentRunsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunsResponse
type ListAssessmentRunsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs that specifies the assessment runs that are returned by the
	// action.
	//
	// AssessmentRunArns is a required field
	AssessmentRunArns []string `locationName:"assessmentRunArns" type:"list" required:"true"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssessmentRunsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssessmentRuns = "ListAssessmentRuns"

// ListAssessmentRunsRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Lists the assessment runs that correspond to the assessment templates that
// are specified by the ARNs of the assessment templates.
//
//    // Example sending a request using ListAssessmentRunsRequest.
//    req := client.ListAssessmentRunsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns
func (c *Client) ListAssessmentRunsRequest(input *ListAssessmentRunsInput) ListAssessmentRunsRequest {
	op := &aws.Operation{
		Name:       opListAssessmentRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssessmentRunsInput{}
	}

	req := c.newRequest(op, input, &ListAssessmentRunsOutput{})
	return ListAssessmentRunsRequest{Request: req, Input: input, Copy: c.ListAssessmentRunsRequest}
}

// ListAssessmentRunsRequest is the request type for the
// ListAssessmentRuns API operation.
type ListAssessmentRunsRequest struct {
	*aws.Request
	Input *ListAssessmentRunsInput
	Copy  func(*ListAssessmentRunsInput) ListAssessmentRunsRequest
}

// Send marshals and sends the ListAssessmentRuns API request.
func (r ListAssessmentRunsRequest) Send(ctx context.Context) (*ListAssessmentRunsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssessmentRunsResponse{
		ListAssessmentRunsOutput: r.Request.Data.(*ListAssessmentRunsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAssessmentRunsRequestPaginator returns a paginator for ListAssessmentRuns.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAssessmentRunsRequest(input)
//   p := inspector.NewListAssessmentRunsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAssessmentRunsPaginator(req ListAssessmentRunsRequest) ListAssessmentRunsPaginator {
	return ListAssessmentRunsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAssessmentRunsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAssessmentRunsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAssessmentRunsPaginator struct {
	aws.Pager
}

func (p *ListAssessmentRunsPaginator) CurrentPage() *ListAssessmentRunsOutput {
	return p.Pager.CurrentPage().(*ListAssessmentRunsOutput)
}

// ListAssessmentRunsResponse is the response type for the
// ListAssessmentRuns API operation.
type ListAssessmentRunsResponse struct {
	*ListAssessmentRunsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssessmentRuns request.
func (r *ListAssessmentRunsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
