// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListViolationEventsInput struct {
	_ struct{} `type:"structure"`

	// The end time for the alerts to be listed.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A filter to limit results to those alerts generated by the specified security
	// profile.
	SecurityProfileName *string `location:"querystring" locationName:"securityProfileName" min:"1" type:"string"`

	// The start time for the alerts to be listed.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// A filter to limit results to those alerts caused by the specified thing.
	ThingName *string `location:"querystring" locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListViolationEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListViolationEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListViolationEventsInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListViolationEventsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endTime", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityProfileName != nil {
		v := *s.SecurityProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "securityProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startTime", protocol.TimeValue{V: v, Format: protocol.RFC822TimeFromat}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListViolationEventsOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The security profile violation alerts issued for this account during the
	// given time frame, potentially filtered by security profile, behavior violated,
	// or thing (device) violating.
	ViolationEvents []ViolationEvent `locationName:"violationEvents" type:"list"`
}

// String returns the string representation
func (s ListViolationEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListViolationEventsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ViolationEvents) > 0 {
		v := s.ViolationEvents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "violationEvents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListViolationEvents = "ListViolationEvents"

// ListViolationEventsRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the Device Defender security profile violations discovered during the
// given time period. You can use filters to limit the results to those alerts
// issued for a particular security profile, behavior or thing (device).
//
//    // Example sending a request using ListViolationEventsRequest.
//    req := client.ListViolationEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListViolationEventsRequest(input *ListViolationEventsInput) ListViolationEventsRequest {
	op := &aws.Operation{
		Name:       opListViolationEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/violation-events",
	}

	if input == nil {
		input = &ListViolationEventsInput{}
	}

	req := c.newRequest(op, input, &ListViolationEventsOutput{})
	return ListViolationEventsRequest{Request: req, Input: input, Copy: c.ListViolationEventsRequest}
}

// ListViolationEventsRequest is the request type for the
// ListViolationEvents API operation.
type ListViolationEventsRequest struct {
	*aws.Request
	Input *ListViolationEventsInput
	Copy  func(*ListViolationEventsInput) ListViolationEventsRequest
}

// Send marshals and sends the ListViolationEvents API request.
func (r ListViolationEventsRequest) Send(ctx context.Context) (*ListViolationEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListViolationEventsResponse{
		ListViolationEventsOutput: r.Request.Data.(*ListViolationEventsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListViolationEventsResponse is the response type for the
// ListViolationEvents API operation.
type ListViolationEventsResponse struct {
	*ListViolationEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListViolationEvents request.
func (r *ListViolationEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
