// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateDynamicThingGroupInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the dynamic thing group to update.
	ExpectedVersion *int64 `locationName:"expectedVersion" type:"long"`

	// The dynamic thing group index to update.
	//
	// Currently one index is supported: 'AWS_Things'.
	IndexName *string `locationName:"indexName" min:"1" type:"string"`

	// The dynamic thing group search query string to update.
	QueryString *string `locationName:"queryString" min:"1" type:"string"`

	// The dynamic thing group query version to update.
	//
	// Currently one query version is supported: "2017-09-30". If not specified,
	// the query version defaults to this value.
	QueryVersion *string `locationName:"queryVersion" type:"string"`

	// The name of the dynamic thing group to update.
	//
	// ThingGroupName is a required field
	ThingGroupName *string `location:"uri" locationName:"thingGroupName" min:"1" type:"string" required:"true"`

	// The dynamic thing group properties to update.
	//
	// ThingGroupProperties is a required field
	ThingGroupProperties *ThingGroupProperties `locationName:"thingGroupProperties" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateDynamicThingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDynamicThingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDynamicThingGroupInput"}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 1))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryString", 1))
	}

	if s.ThingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingGroupName"))
	}
	if s.ThingGroupName != nil && len(*s.ThingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingGroupName", 1))
	}

	if s.ThingGroupProperties == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingGroupProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDynamicThingGroupInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ExpectedVersion != nil {
		v := *s.ExpectedVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expectedVersion", protocol.Int64Value(v), metadata)
	}
	if s.IndexName != nil {
		v := *s.IndexName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "indexName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueryString != nil {
		v := *s.QueryString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryString", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueryVersion != nil {
		v := *s.QueryVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "queryVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingGroupProperties != nil {
		v := s.ThingGroupProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "thingGroupProperties", v, metadata)
	}
	if s.ThingGroupName != nil {
		v := *s.ThingGroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "thingGroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDynamicThingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The dynamic thing group version.
	Version *int64 `locationName:"version" type:"long"`
}

// String returns the string representation
func (s UpdateDynamicThingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDynamicThingGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opUpdateDynamicThingGroup = "UpdateDynamicThingGroup"

// UpdateDynamicThingGroupRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates a dynamic thing group.
//
//    // Example sending a request using UpdateDynamicThingGroupRequest.
//    req := client.UpdateDynamicThingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateDynamicThingGroupRequest(input *UpdateDynamicThingGroupInput) UpdateDynamicThingGroupRequest {
	op := &aws.Operation{
		Name:       opUpdateDynamicThingGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/dynamic-thing-groups/{thingGroupName}",
	}

	if input == nil {
		input = &UpdateDynamicThingGroupInput{}
	}

	req := c.newRequest(op, input, &UpdateDynamicThingGroupOutput{})
	return UpdateDynamicThingGroupRequest{Request: req, Input: input, Copy: c.UpdateDynamicThingGroupRequest}
}

// UpdateDynamicThingGroupRequest is the request type for the
// UpdateDynamicThingGroup API operation.
type UpdateDynamicThingGroupRequest struct {
	*aws.Request
	Input *UpdateDynamicThingGroupInput
	Copy  func(*UpdateDynamicThingGroupInput) UpdateDynamicThingGroupRequest
}

// Send marshals and sends the UpdateDynamicThingGroup API request.
func (r UpdateDynamicThingGroupRequest) Send(ctx context.Context) (*UpdateDynamicThingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDynamicThingGroupResponse{
		UpdateDynamicThingGroupOutput: r.Request.Data.(*UpdateDynamicThingGroupOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDynamicThingGroupResponse is the response type for the
// UpdateDynamicThingGroup API operation.
type UpdateDynamicThingGroupResponse struct {
	*UpdateDynamicThingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDynamicThingGroup request.
func (r *UpdateDynamicThingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
