// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input for DeleteStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStreamInput
type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// If this parameter is unset (null) or if you set it to false, and the stream
	// has registered consumers, the call to DeleteStream fails with a ResourceInUseException.
	EnforceConsumerDeletion *bool `type:"boolean"`

	// The name of the stream to delete.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStreamInput"}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStreamOutput
type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest returns a request value for making API operation for
// Amazon Kinesis.
//
// Deletes a Kinesis data stream and all its shards and data. You must shut
// down any applications that are operating on the stream before you delete
// the stream. If an application attempts to operate on a deleted stream, it
// receives the exception ResourceNotFoundException.
//
// If the stream is in the ACTIVE state, you can delete it. After a DeleteStream
// request, the specified stream is in the DELETING state until Kinesis Data
// Streams completes the deletion.
//
// Note: Kinesis Data Streams might continue to accept data read and write operations,
// such as PutRecord, PutRecords, and GetRecords, on a stream in the DELETING
// state until the stream deletion is complete.
//
// When you delete a stream, any shards in that stream are also deleted, and
// any tags are dissociated from the stream.
//
// You can use the DescribeStream operation to check the state of the stream,
// which is returned in StreamStatus.
//
// DeleteStream has a limit of five transactions per second per account.
//
//    // Example sending a request using DeleteStreamRequest.
//    req := client.DeleteStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream
func (c *Client) DeleteStreamRequest(input *DeleteStreamInput) DeleteStreamRequest {
	op := &aws.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	req := c.newRequest(op, input, &DeleteStreamOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteStreamRequest{Request: req, Input: input, Copy: c.DeleteStreamRequest}
}

// DeleteStreamRequest is the request type for the
// DeleteStream API operation.
type DeleteStreamRequest struct {
	*aws.Request
	Input *DeleteStreamInput
	Copy  func(*DeleteStreamInput) DeleteStreamRequest
}

// Send marshals and sends the DeleteStream API request.
func (r DeleteStreamRequest) Send(ctx context.Context) (*DeleteStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStreamResponse{
		DeleteStreamOutput: r.Request.Data.(*DeleteStreamOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStreamResponse is the response type for the
// DeleteStream API operation.
type DeleteStreamResponse struct {
	*DeleteStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStream request.
func (r *DeleteStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
