// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStoresRequest
type DescribeCustomKeyStoresInput struct {
	_ struct{} `type:"structure"`

	// Gets only information about the specified custom key store. Enter the key
	// store ID.
	//
	// By default, this operation gets information about all custom key stores in
	// the account and region. To limit the output to a particular custom key store,
	// you can use either the CustomKeyStoreId or CustomKeyStoreName parameter,
	// but not both.
	CustomKeyStoreId *string `min:"1" type:"string"`

	// Gets only information about the specified custom key store. Enter the friendly
	// name of the custom key store.
	//
	// By default, this operation gets information about all custom key stores in
	// the account and region. To limit the output to a particular custom key store,
	// you can use either the CustomKeyStoreId or CustomKeyStoreName parameter,
	// but not both.
	CustomKeyStoreName *string `min:"1" type:"string"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, AWS KMS does not return more than the specified number
	// of items, but it might return fewer.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeCustomKeyStoresInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomKeyStoresInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCustomKeyStoresInput"}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomKeyStoreId", 1))
	}
	if s.CustomKeyStoreName != nil && len(*s.CustomKeyStoreName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomKeyStoreName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStoresResponse
type DescribeCustomKeyStoresOutput struct {
	_ struct{} `type:"structure"`

	// Contains metadata about each custom key store.
	CustomKeyStores []CustomKeyStoresListEntry `type:"list"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeCustomKeyStoresOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCustomKeyStores = "DescribeCustomKeyStores"

// DescribeCustomKeyStoresRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Gets information about custom key stores (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// in the account and region.
//
// This operation is part of the Custom Key Store feature (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
// feature in AWS KMS, which combines the convenience and extensive integration
// of AWS KMS with the isolation and control of a single-tenant key store.
//
// By default, this operation returns information about all custom key stores
// in the account and region. To get only information about a particular custom
// key store, use either the CustomKeyStoreName or CustomKeyStoreId parameter
// (but not both).
//
// To determine whether the custom key store is connected to its AWS CloudHSM
// cluster, use the ConnectionState element in the response. If an attempt to
// connect the custom key store failed, the ConnectionState value is FAILED
// and the ConnectionErrorCode element in the response indicates the cause of
// the failure. For help interpreting the ConnectionErrorCode, see CustomKeyStoresListEntry.
//
// Custom key stores have a DISCONNECTED connection state if the key store has
// never been connected or you use the DisconnectCustomKeyStore operation to
// disconnect it. If your custom key store state is CONNECTED but you are having
// trouble using it, make sure that its associated AWS CloudHSM cluster is active
// and contains the minimum number of HSMs required for the operation, if any.
//
// For help repairing your custom key store, see the Troubleshooting Custom
// Key Stores (https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
// topic in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using DescribeCustomKeyStoresRequest.
//    req := client.DescribeCustomKeyStoresRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/DescribeCustomKeyStores
func (c *Client) DescribeCustomKeyStoresRequest(input *DescribeCustomKeyStoresInput) DescribeCustomKeyStoresRequest {
	op := &aws.Operation{
		Name:       opDescribeCustomKeyStores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomKeyStoresInput{}
	}

	req := c.newRequest(op, input, &DescribeCustomKeyStoresOutput{})
	return DescribeCustomKeyStoresRequest{Request: req, Input: input, Copy: c.DescribeCustomKeyStoresRequest}
}

// DescribeCustomKeyStoresRequest is the request type for the
// DescribeCustomKeyStores API operation.
type DescribeCustomKeyStoresRequest struct {
	*aws.Request
	Input *DescribeCustomKeyStoresInput
	Copy  func(*DescribeCustomKeyStoresInput) DescribeCustomKeyStoresRequest
}

// Send marshals and sends the DescribeCustomKeyStores API request.
func (r DescribeCustomKeyStoresRequest) Send(ctx context.Context) (*DescribeCustomKeyStoresResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCustomKeyStoresResponse{
		DescribeCustomKeyStoresOutput: r.Request.Data.(*DescribeCustomKeyStoresOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCustomKeyStoresResponse is the response type for the
// DescribeCustomKeyStores API operation.
type DescribeCustomKeyStoresResponse struct {
	*DescribeCustomKeyStoresOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCustomKeyStores request.
func (r *DescribeCustomKeyStoresResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
