// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Limits that are related to concurrency and code storage. All file and storage
// sizes are in bytes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AccountLimit
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The maximum size of your function's code and layers when they're extracted.
	CodeSizeUnzipped *int64 `type:"long"`

	// The maximum size of a deployment package when it's uploaded directly to AWS
	// Lambda. Use Amazon S3 for larger files.
	CodeSizeZipped *int64 `type:"long"`

	// The maximum number of simultaneous function executions.
	ConcurrentExecutions *int64 `type:"integer"`

	// The amount of storage space that you can use for all deployment packages
	// and layer archives.
	TotalCodeSize *int64 `type:"long"`

	// The maximum number of simultaneous function executions, minus the capacity
	// that's reserved for individual functions with PutFunctionConcurrency.
	UnreservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountLimit) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeSizeUnzipped != nil {
		v := *s.CodeSizeUnzipped

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSizeUnzipped", protocol.Int64Value(v), metadata)
	}
	if s.CodeSizeZipped != nil {
		v := *s.CodeSizeZipped

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSizeZipped", protocol.Int64Value(v), metadata)
	}
	if s.ConcurrentExecutions != nil {
		v := *s.ConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	if s.TotalCodeSize != nil {
		v := *s.TotalCodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCodeSize", protocol.Int64Value(v), metadata)
	}
	if s.UnreservedConcurrentExecutions != nil {
		v := *s.UnreservedConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UnreservedConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The number of functions and amount of storage in use.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AccountUsage
type AccountUsage struct {
	_ struct{} `type:"structure"`

	// The number of Lambda functions.
	FunctionCount *int64 `type:"long"`

	// The amount of storage space, in bytes, that's being used by deployment packages
	// and layer archives.
	TotalCodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s AccountUsage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountUsage) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionCount != nil {
		v := *s.FunctionCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionCount", protocol.Int64Value(v), metadata)
	}
	if s.TotalCodeSize != nil {
		v := *s.TotalCodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TotalCodeSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Provides configuration information about a Lambda function alias (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AliasConfiguration
type AliasConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alias.
	AliasArn *string `type:"string"`

	// A description of the alias.
	Description *string `type:"string"`

	// The function version that the alias invokes.
	FunctionVersion *string `min:"1" type:"string"`

	// The name of the alias.
	Name *string `min:"1" type:"string"`

	// A unique identifier that changes when you update the alias.
	RevisionId *string `type:"string"`

	// The routing configuration (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
	// of the alias.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s AliasConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AliasConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AliasArn != nil {
		v := *s.AliasArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AliasArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionVersion != nil {
		v := *s.FunctionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoutingConfig != nil {
		v := s.RoutingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RoutingConfig", v, metadata)
	}
	return nil
}

// The traffic-shifting (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
// configuration of a Lambda function alias.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AliasRoutingConfiguration
type AliasRoutingConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the second alias, and the percentage of traffic that's routed
	// to it.
	AdditionalVersionWeights map[string]float64 `type:"map"`
}

// String returns the string representation
func (s AliasRoutingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AliasRoutingConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AdditionalVersionWeights) > 0 {
		v := s.AdditionalVersionWeights

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "AdditionalVersionWeights", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Float64Value(v1))
		}
		ms0.End()

	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Concurrency
type Concurrency struct {
	_ struct{} `type:"structure"`

	// The number of concurrent executions that are reserved for this function.
	// For more information, see Managing Concurrency (https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	ReservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s Concurrency) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Concurrency) MarshalFields(e protocol.FieldEncoder) error {
	if s.ReservedConcurrentExecutions != nil {
		v := *s.ReservedConcurrentExecutions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedConcurrentExecutions", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The dead letter queue (https://docs.aws.amazon.com/lambda/latest/dg/dlq.html)
// for failed asynchronous invocations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeadLetterConfig
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeadLetterConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetArn != nil {
		v := *s.TargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A function's environment variable settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Environment
type Environment struct {
	_ struct{} `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]string `type:"map"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Environment) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Variables) > 0 {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Error messages for environment variables that couldn't be applied.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/EnvironmentError
type EnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnvironmentError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The results of a configuration update that applied environment variables.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/EnvironmentResponse
type EnvironmentResponse struct {
	_ struct{} `type:"structure"`

	// Error messages for environment variables that couldn't be applied.
	Error *EnvironmentError `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]string `type:"map"`
}

// String returns the string representation
func (s EnvironmentResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnvironmentResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.Error != nil {
		v := s.Error

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Error", v, metadata)
	}
	if len(s.Variables) > 0 {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// A mapping between an AWS resource and an AWS Lambda function. See CreateEventSourceMapping
// for details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/EventSourceMappingConfiguration
type EventSourceMappingConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string `type:"string"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The date that the event source mapping was last updated.
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be one of the following: Creating,
	// Enabling, Enabled, Disabling, Disabled, Updating, or Deleting.
	State *string `type:"string"`

	// The cause of the last state change, either User initiated or Lambda initiated.
	StateTransitionReason *string `type:"string"`

	// The identifier of the event source mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s EventSourceMappingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventSourceMappingConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BatchSize", protocol.Int64Value(v), metadata)
	}
	if s.EventSourceArn != nil {
		v := *s.EventSourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EventSourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastProcessingResult != nil {
		v := *s.LastProcessingResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastProcessingResult", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StateTransitionReason != nil {
		v := *s.StateTransitionReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StateTransitionReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UUID != nil {
		v := *s.UUID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UUID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The code for the Lambda function. You can specify either an object in Amazon
// S3, or upload a deployment package directly.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/FunctionCode
type FunctionCode struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket in the same AWS Region as your function. The bucket can
	// be in a different AWS account.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `min:"1" type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The base64-encoded contents of the deployment package. AWS SDK and AWS CLI
	// clients handle the encoding for you.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s FunctionCode) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionCode) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FunctionCode"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionCode) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3ObjectVersion != nil {
		v := *s.S3ObjectVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3ObjectVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipFile != nil {
		v := s.ZipFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipFile", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// Details about a function's deployment package.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/FunctionCodeLocation
type FunctionCodeLocation struct {
	_ struct{} `type:"structure"`

	// A presigned URL that you can use to download the deployment package.
	Location *string `type:"string"`

	// The service that's hosting the file.
	RepositoryType *string `type:"string"`
}

// String returns the string representation
func (s FunctionCodeLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionCodeLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepositoryType != nil {
		v := *s.RepositoryType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RepositoryType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about a function's configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/FunctionConfiguration
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string `type:"string"`

	// The size of the function's deployment package, in bytes.
	CodeSize *int64 `type:"long"`

	// The function's dead letter queue.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The function's description.
	Description *string `type:"string"`

	// The function's environment variables.
	Environment *EnvironmentResponse `type:"structure"`

	// The function's Amazon Resource Name (ARN).
	FunctionArn *string `type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The function that Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The KMS key that's used to encrypt the function's environment variables.
	// This key is only returned if you've configured a customer-managed CMK.
	KMSKeyArn *string `type:"string"`

	// The date and time that the function was last updated, in ISO-8601 format
	// (https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModified *string `type:"string"`

	// The function's layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
	Layers []Layer `type:"list"`

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string `type:"string"`

	// The memory that's allocated to the function.
	MemorySize *int64 `min:"128" type:"integer"`

	// The latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The function's execution role.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime Runtime `type:"string" enum:"true"`

	// The amount of time that Lambda allows a function to run before stopping it.
	Timeout *int64 `min:"1" type:"integer"`

	// The function's AWS X-Ray tracing configuration.
	TracingConfig *TracingConfigResponse `type:"structure"`

	// The version of the Lambda function.
	Version *string `min:"1" type:"string"`

	// The function's networking configuration.
	VpcConfig *VpcConfigResponse `type:"structure"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeSha256 != nil {
		v := *s.CodeSha256

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSha256", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CodeSize != nil {
		v := *s.CodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSize", protocol.Int64Value(v), metadata)
	}
	if s.DeadLetterConfig != nil {
		v := s.DeadLetterConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeadLetterConfig", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Environment != nil {
		v := s.Environment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Environment", v, metadata)
	}
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Handler != nil {
		v := *s.Handler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Handler", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KMSKeyArn != nil {
		v := *s.KMSKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Layers) > 0 {
		v := s.Layers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Layers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MasterArn != nil {
		v := *s.MasterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MasterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemorySize != nil {
		v := *s.MemorySize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemorySize", protocol.Int64Value(v), metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Runtime) > 0 {
		v := s.Runtime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Runtime", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	if s.TracingConfig != nil {
		v := s.TracingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TracingConfig", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	return nil
}

// An AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Layer
type Layer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string `min:"1" type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Layer) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CodeSize != nil {
		v := *s.CodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A ZIP archive that contains the contents of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// You can specify either an Amazon S3 location, or upload a layer archive directly.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/LayerVersionContentInput
type LayerVersionContentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket of the layer archive.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 key of the layer archive.
	S3Key *string `min:"1" type:"string"`

	// For versioned objects, the version of the layer archive object to use.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The base64-encoded contents of the layer archive. AWS SDK and AWS CLI clients
	// handle the encoding for you.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s LayerVersionContentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LayerVersionContentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LayerVersionContentInput"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LayerVersionContentInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3ObjectVersion != nil {
		v := *s.S3ObjectVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3ObjectVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipFile != nil {
		v := s.ZipFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipFile", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// Details about a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/LayerVersionContentOutput
type LayerVersionContentOutput struct {
	_ struct{} `type:"structure"`

	// The SHA-256 hash of the layer archive.
	CodeSha256 *string `type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"long"`

	// A link to the layer archive in Amazon S3 that is valid for 10 minutes.
	Location *string `type:"string"`
}

// String returns the string representation
func (s LayerVersionContentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LayerVersionContentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CodeSha256 != nil {
		v := *s.CodeSha256

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSha256", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CodeSize != nil {
		v := *s.CodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSize", protocol.Int64Value(v), metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/LayerVersionsListItem
type LayerVersionsListItem struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []Runtime `type:"list"`

	// The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's open-source license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s LayerVersionsListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LayerVersionsListItem) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CompatibleRuntimes) > 0 {
		v := s.CompatibleRuntimes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CompatibleRuntimes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LayerVersionArn != nil {
		v := *s.LayerVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LayerVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LicenseInfo != nil {
		v := *s.LicenseInfo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LicenseInfo", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Details about an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/LayersListItem
type LayersListItem struct {
	_ struct{} `type:"structure"`

	// The newest version of the layer.
	LatestMatchingVersion *LayerVersionsListItem `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	LayerArn *string `min:"1" type:"string"`

	// The name of the layer.
	LayerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LayersListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LayersListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.LatestMatchingVersion != nil {
		v := s.LatestMatchingVersion

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LatestMatchingVersion", v, metadata)
	}
	if s.LayerArn != nil {
		v := *s.LayerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LayerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LayerName != nil {
		v := *s.LayerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LayerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The function's AWS X-Ray tracing configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TracingConfig
type TracingConfig struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode TracingMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s TracingConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TracingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The function's AWS X-Ray tracing configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TracingConfigResponse
type TracingConfigResponse struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode TracingMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s TracingConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TracingConfigResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The VPC security groups and subnets that are attached to a Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/VpcConfig
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.SecurityGroupIds) > 0 {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.SubnetIds) > 0 {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The VPC security groups and subnets that are attached to a Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/VpcConfigResponse
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcConfigResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.SecurityGroupIds) > 0 {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.SubnetIds) > 0 {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
