// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package licensemanageriface provides an interface to enable mocking the AWS License Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package licensemanageriface

import (
	"github.com/aws/aws-sdk-go-v2/service/licensemanager"
)

// ClientAPI provides an interface to enable mocking the
// licensemanager.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS License Manager.
//    func myFunc(svc licensemanageriface.ClientAPI) bool {
//        // Make svc.CreateLicenseConfiguration request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := licensemanager.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        licensemanageriface.ClientPI
//    }
//    func (m *mockClientClient) CreateLicenseConfiguration(input *licensemanager.CreateLicenseConfigurationInput) (*licensemanager.CreateLicenseConfigurationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateLicenseConfigurationRequest(*licensemanager.CreateLicenseConfigurationInput) licensemanager.CreateLicenseConfigurationRequest

	DeleteLicenseConfigurationRequest(*licensemanager.DeleteLicenseConfigurationInput) licensemanager.DeleteLicenseConfigurationRequest

	GetLicenseConfigurationRequest(*licensemanager.GetLicenseConfigurationInput) licensemanager.GetLicenseConfigurationRequest

	GetServiceSettingsRequest(*licensemanager.GetServiceSettingsInput) licensemanager.GetServiceSettingsRequest

	ListAssociationsForLicenseConfigurationRequest(*licensemanager.ListAssociationsForLicenseConfigurationInput) licensemanager.ListAssociationsForLicenseConfigurationRequest

	ListLicenseConfigurationsRequest(*licensemanager.ListLicenseConfigurationsInput) licensemanager.ListLicenseConfigurationsRequest

	ListLicenseSpecificationsForResourceRequest(*licensemanager.ListLicenseSpecificationsForResourceInput) licensemanager.ListLicenseSpecificationsForResourceRequest

	ListResourceInventoryRequest(*licensemanager.ListResourceInventoryInput) licensemanager.ListResourceInventoryRequest

	ListTagsForResourceRequest(*licensemanager.ListTagsForResourceInput) licensemanager.ListTagsForResourceRequest

	ListUsageForLicenseConfigurationRequest(*licensemanager.ListUsageForLicenseConfigurationInput) licensemanager.ListUsageForLicenseConfigurationRequest

	TagResourceRequest(*licensemanager.TagResourceInput) licensemanager.TagResourceRequest

	UntagResourceRequest(*licensemanager.UntagResourceInput) licensemanager.UntagResourceRequest

	UpdateLicenseConfigurationRequest(*licensemanager.UpdateLicenseConfigurationInput) licensemanager.UpdateLicenseConfigurationRequest

	UpdateLicenseSpecificationsForResourceRequest(*licensemanager.UpdateLicenseSpecificationsForResourceInput) licensemanager.UpdateLicenseSpecificationsForResourceRequest

	UpdateServiceSettingsRequest(*licensemanager.UpdateServiceSettingsInput) licensemanager.UpdateServiceSettingsRequest
}

var _ ClientAPI = (*licensemanager.Client)(nil)
