// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesRequest
type CreateInstancesInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create your instance. Use the following
	// format: us-east-2a (case sensitive). You can get a list of Availability Zones
	// by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include Availability Zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The ID for a virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0).
	// Use the get blueprints operation to return a list of available images (or
	// blueprints).
	//
	// BlueprintId is a required field
	BlueprintId *string `locationName:"blueprintId" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// (Deprecated) The name for your custom image.
	//
	// In releases prior to June 12, 2017, this parameter was ignored by the API.
	// It is now deprecated.
	CustomImageName *string `locationName:"customImageName" deprecated:"true" type:"string"`

	// The names to use for your new Lightsail instances. Separate multiple values
	// using quotation marks and commas, for example: ["MyFirstInstance","MySecondInstance"]
	//
	// InstanceNames is a required field
	InstanceNames []string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// The tag keys and optional values to add to the resource during create.
	//
	// To tag a resource after it has been created, see the tag resource operation.
	Tags []Tag `locationName:"tags" type:"list"`

	// A launch script you can create that configures a server with additional user
	// data. For example, you might want to run apt-get -y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Dev Guide
	// (https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInstancesInput"}

	if s.AvailabilityZone == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZone"))
	}

	if s.BlueprintId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlueprintId"))
	}

	if s.BundleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BundleId"))
	}

	if s.InstanceNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesResult
type CreateInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateInstances = "CreateInstances"

// CreateInstancesRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Creates one or more Amazon Lightsail virtual private servers, or instances.
// Create instances using active blueprints. Inactive blueprints are listed
// to support customers with existing instances but are not necessarily available
// for launch of new instances. Blueprints are marked inactive when they become
// outdated due to operating system updates or new application releases. Use
// the get blueprints operation to return a list of available blueprints.
//
// The create instances operation supports tag-based access control via request
// tags. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using CreateInstancesRequest.
//    req := client.CreateInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances
func (c *Client) CreateInstancesRequest(input *CreateInstancesInput) CreateInstancesRequest {
	op := &aws.Operation{
		Name:       opCreateInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesInput{}
	}

	req := c.newRequest(op, input, &CreateInstancesOutput{})
	return CreateInstancesRequest{Request: req, Input: input, Copy: c.CreateInstancesRequest}
}

// CreateInstancesRequest is the request type for the
// CreateInstances API operation.
type CreateInstancesRequest struct {
	*aws.Request
	Input *CreateInstancesInput
	Copy  func(*CreateInstancesInput) CreateInstancesRequest
}

// Send marshals and sends the CreateInstances API request.
func (r CreateInstancesRequest) Send(ctx context.Context) (*CreateInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInstancesResponse{
		CreateInstancesOutput: r.Request.Data.(*CreateInstancesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInstancesResponse is the response type for the
// CreateInstances API operation.
type CreateInstancesResponse struct {
	*CreateInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInstances request.
func (r *CreateInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
