// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshotRequest
type CreateRelationalDatabaseSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the database on which to base your new snapshot.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The name for your new database snapshot.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	//
	// RelationalDatabaseSnapshotName is a required field
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string" required:"true"`

	// The tag keys and optional values to add to the resource during create.
	//
	// To tag a resource after it has been created, see the tag resource operation.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelationalDatabaseSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRelationalDatabaseSnapshotInput"}

	if s.RelationalDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseName"))
	}

	if s.RelationalDatabaseSnapshotName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshotResult
type CreateRelationalDatabaseSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your create relational database snapshot
	// request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateRelationalDatabaseSnapshot = "CreateRelationalDatabaseSnapshot"

// CreateRelationalDatabaseSnapshotRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Creates a snapshot of your database in Amazon Lightsail. You can use snapshots
// for backups, to make copies of a database, and to save data before deleting
// a database.
//
// The create relational database snapshot operation supports tag-based access
// control via request tags. For more information, see the Lightsail Dev Guide
// (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using CreateRelationalDatabaseSnapshotRequest.
//    req := client.CreateRelationalDatabaseSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot
func (c *Client) CreateRelationalDatabaseSnapshotRequest(input *CreateRelationalDatabaseSnapshotInput) CreateRelationalDatabaseSnapshotRequest {
	op := &aws.Operation{
		Name:       opCreateRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelationalDatabaseSnapshotInput{}
	}

	req := c.newRequest(op, input, &CreateRelationalDatabaseSnapshotOutput{})
	return CreateRelationalDatabaseSnapshotRequest{Request: req, Input: input, Copy: c.CreateRelationalDatabaseSnapshotRequest}
}

// CreateRelationalDatabaseSnapshotRequest is the request type for the
// CreateRelationalDatabaseSnapshot API operation.
type CreateRelationalDatabaseSnapshotRequest struct {
	*aws.Request
	Input *CreateRelationalDatabaseSnapshotInput
	Copy  func(*CreateRelationalDatabaseSnapshotInput) CreateRelationalDatabaseSnapshotRequest
}

// Send marshals and sends the CreateRelationalDatabaseSnapshot API request.
func (r CreateRelationalDatabaseSnapshotRequest) Send(ctx context.Context) (*CreateRelationalDatabaseSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRelationalDatabaseSnapshotResponse{
		CreateRelationalDatabaseSnapshotOutput: r.Request.Data.(*CreateRelationalDatabaseSnapshotOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRelationalDatabaseSnapshotResponse is the response type for the
// CreateRelationalDatabaseSnapshot API operation.
type CreateRelationalDatabaseSnapshotResponse struct {
	*CreateRelationalDatabaseSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRelationalDatabaseSnapshot request.
func (r *CreateRelationalDatabaseSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
