// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshotsRequest
type GetDiskSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your GetDiskSnapshots
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetDiskSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshotsResult
type GetDiskSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects containing information about all block storage disk snapshots.
	DiskSnapshots []DiskSnapshot `locationName:"diskSnapshots" type:"list"`

	// A token used for advancing to the next page of results from your GetDiskSnapshots
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetDiskSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDiskSnapshots = "GetDiskSnapshots"

// GetDiskSnapshotsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about all block storage disk snapshots in your AWS account
// and region.
//
// If you are describing a long list of disk snapshots, you can paginate the
// output to make the list more manageable. You can use the pageToken and nextPageToken
// values to retrieve the next items in the list.
//
//    // Example sending a request using GetDiskSnapshotsRequest.
//    req := client.GetDiskSnapshotsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots
func (c *Client) GetDiskSnapshotsRequest(input *GetDiskSnapshotsInput) GetDiskSnapshotsRequest {
	op := &aws.Operation{
		Name:       opGetDiskSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskSnapshotsInput{}
	}

	req := c.newRequest(op, input, &GetDiskSnapshotsOutput{})
	return GetDiskSnapshotsRequest{Request: req, Input: input, Copy: c.GetDiskSnapshotsRequest}
}

// GetDiskSnapshotsRequest is the request type for the
// GetDiskSnapshots API operation.
type GetDiskSnapshotsRequest struct {
	*aws.Request
	Input *GetDiskSnapshotsInput
	Copy  func(*GetDiskSnapshotsInput) GetDiskSnapshotsRequest
}

// Send marshals and sends the GetDiskSnapshots API request.
func (r GetDiskSnapshotsRequest) Send(ctx context.Context) (*GetDiskSnapshotsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDiskSnapshotsResponse{
		GetDiskSnapshotsOutput: r.Request.Data.(*GetDiskSnapshotsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDiskSnapshotsResponse is the response type for the
// GetDiskSnapshots API operation.
type GetDiskSnapshotsResponse struct {
	*GetDiskSnapshotsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDiskSnapshots request.
func (r *GetDiskSnapshotsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
