// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package lightsailiface provides an interface to enable mocking the Amazon Lightsail service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package lightsailiface

import (
	"github.com/aws/aws-sdk-go-v2/service/lightsail"
)

// ClientAPI provides an interface to enable mocking the
// lightsail.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Lightsail.
//    func myFunc(svc lightsailiface.ClientAPI) bool {
//        // Make svc.AllocateStaticIp request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := lightsail.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        lightsailiface.ClientPI
//    }
//    func (m *mockClientClient) AllocateStaticIp(input *lightsail.AllocateStaticIpInput) (*lightsail.AllocateStaticIpOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AllocateStaticIpRequest(*lightsail.AllocateStaticIpInput) lightsail.AllocateStaticIpRequest

	AttachDiskRequest(*lightsail.AttachDiskInput) lightsail.AttachDiskRequest

	AttachInstancesToLoadBalancerRequest(*lightsail.AttachInstancesToLoadBalancerInput) lightsail.AttachInstancesToLoadBalancerRequest

	AttachLoadBalancerTlsCertificateRequest(*lightsail.AttachLoadBalancerTlsCertificateInput) lightsail.AttachLoadBalancerTlsCertificateRequest

	AttachStaticIpRequest(*lightsail.AttachStaticIpInput) lightsail.AttachStaticIpRequest

	CloseInstancePublicPortsRequest(*lightsail.CloseInstancePublicPortsInput) lightsail.CloseInstancePublicPortsRequest

	CopySnapshotRequest(*lightsail.CopySnapshotInput) lightsail.CopySnapshotRequest

	CreateCloudFormationStackRequest(*lightsail.CreateCloudFormationStackInput) lightsail.CreateCloudFormationStackRequest

	CreateDiskRequest(*lightsail.CreateDiskInput) lightsail.CreateDiskRequest

	CreateDiskFromSnapshotRequest(*lightsail.CreateDiskFromSnapshotInput) lightsail.CreateDiskFromSnapshotRequest

	CreateDiskSnapshotRequest(*lightsail.CreateDiskSnapshotInput) lightsail.CreateDiskSnapshotRequest

	CreateDomainRequest(*lightsail.CreateDomainInput) lightsail.CreateDomainRequest

	CreateDomainEntryRequest(*lightsail.CreateDomainEntryInput) lightsail.CreateDomainEntryRequest

	CreateInstanceSnapshotRequest(*lightsail.CreateInstanceSnapshotInput) lightsail.CreateInstanceSnapshotRequest

	CreateInstancesRequest(*lightsail.CreateInstancesInput) lightsail.CreateInstancesRequest

	CreateInstancesFromSnapshotRequest(*lightsail.CreateInstancesFromSnapshotInput) lightsail.CreateInstancesFromSnapshotRequest

	CreateKeyPairRequest(*lightsail.CreateKeyPairInput) lightsail.CreateKeyPairRequest

	CreateLoadBalancerRequest(*lightsail.CreateLoadBalancerInput) lightsail.CreateLoadBalancerRequest

	CreateLoadBalancerTlsCertificateRequest(*lightsail.CreateLoadBalancerTlsCertificateInput) lightsail.CreateLoadBalancerTlsCertificateRequest

	CreateRelationalDatabaseRequest(*lightsail.CreateRelationalDatabaseInput) lightsail.CreateRelationalDatabaseRequest

	CreateRelationalDatabaseFromSnapshotRequest(*lightsail.CreateRelationalDatabaseFromSnapshotInput) lightsail.CreateRelationalDatabaseFromSnapshotRequest

	CreateRelationalDatabaseSnapshotRequest(*lightsail.CreateRelationalDatabaseSnapshotInput) lightsail.CreateRelationalDatabaseSnapshotRequest

	DeleteDiskRequest(*lightsail.DeleteDiskInput) lightsail.DeleteDiskRequest

	DeleteDiskSnapshotRequest(*lightsail.DeleteDiskSnapshotInput) lightsail.DeleteDiskSnapshotRequest

	DeleteDomainRequest(*lightsail.DeleteDomainInput) lightsail.DeleteDomainRequest

	DeleteDomainEntryRequest(*lightsail.DeleteDomainEntryInput) lightsail.DeleteDomainEntryRequest

	DeleteInstanceRequest(*lightsail.DeleteInstanceInput) lightsail.DeleteInstanceRequest

	DeleteInstanceSnapshotRequest(*lightsail.DeleteInstanceSnapshotInput) lightsail.DeleteInstanceSnapshotRequest

	DeleteKeyPairRequest(*lightsail.DeleteKeyPairInput) lightsail.DeleteKeyPairRequest

	DeleteKnownHostKeysRequest(*lightsail.DeleteKnownHostKeysInput) lightsail.DeleteKnownHostKeysRequest

	DeleteLoadBalancerRequest(*lightsail.DeleteLoadBalancerInput) lightsail.DeleteLoadBalancerRequest

	DeleteLoadBalancerTlsCertificateRequest(*lightsail.DeleteLoadBalancerTlsCertificateInput) lightsail.DeleteLoadBalancerTlsCertificateRequest

	DeleteRelationalDatabaseRequest(*lightsail.DeleteRelationalDatabaseInput) lightsail.DeleteRelationalDatabaseRequest

	DeleteRelationalDatabaseSnapshotRequest(*lightsail.DeleteRelationalDatabaseSnapshotInput) lightsail.DeleteRelationalDatabaseSnapshotRequest

	DetachDiskRequest(*lightsail.DetachDiskInput) lightsail.DetachDiskRequest

	DetachInstancesFromLoadBalancerRequest(*lightsail.DetachInstancesFromLoadBalancerInput) lightsail.DetachInstancesFromLoadBalancerRequest

	DetachStaticIpRequest(*lightsail.DetachStaticIpInput) lightsail.DetachStaticIpRequest

	DownloadDefaultKeyPairRequest(*lightsail.DownloadDefaultKeyPairInput) lightsail.DownloadDefaultKeyPairRequest

	ExportSnapshotRequest(*lightsail.ExportSnapshotInput) lightsail.ExportSnapshotRequest

	GetActiveNamesRequest(*lightsail.GetActiveNamesInput) lightsail.GetActiveNamesRequest

	GetBlueprintsRequest(*lightsail.GetBlueprintsInput) lightsail.GetBlueprintsRequest

	GetBundlesRequest(*lightsail.GetBundlesInput) lightsail.GetBundlesRequest

	GetCloudFormationStackRecordsRequest(*lightsail.GetCloudFormationStackRecordsInput) lightsail.GetCloudFormationStackRecordsRequest

	GetDiskRequest(*lightsail.GetDiskInput) lightsail.GetDiskRequest

	GetDiskSnapshotRequest(*lightsail.GetDiskSnapshotInput) lightsail.GetDiskSnapshotRequest

	GetDiskSnapshotsRequest(*lightsail.GetDiskSnapshotsInput) lightsail.GetDiskSnapshotsRequest

	GetDisksRequest(*lightsail.GetDisksInput) lightsail.GetDisksRequest

	GetDomainRequest(*lightsail.GetDomainInput) lightsail.GetDomainRequest

	GetDomainsRequest(*lightsail.GetDomainsInput) lightsail.GetDomainsRequest

	GetExportSnapshotRecordsRequest(*lightsail.GetExportSnapshotRecordsInput) lightsail.GetExportSnapshotRecordsRequest

	GetInstanceRequest(*lightsail.GetInstanceInput) lightsail.GetInstanceRequest

	GetInstanceAccessDetailsRequest(*lightsail.GetInstanceAccessDetailsInput) lightsail.GetInstanceAccessDetailsRequest

	GetInstanceMetricDataRequest(*lightsail.GetInstanceMetricDataInput) lightsail.GetInstanceMetricDataRequest

	GetInstancePortStatesRequest(*lightsail.GetInstancePortStatesInput) lightsail.GetInstancePortStatesRequest

	GetInstanceSnapshotRequest(*lightsail.GetInstanceSnapshotInput) lightsail.GetInstanceSnapshotRequest

	GetInstanceSnapshotsRequest(*lightsail.GetInstanceSnapshotsInput) lightsail.GetInstanceSnapshotsRequest

	GetInstanceStateRequest(*lightsail.GetInstanceStateInput) lightsail.GetInstanceStateRequest

	GetInstancesRequest(*lightsail.GetInstancesInput) lightsail.GetInstancesRequest

	GetKeyPairRequest(*lightsail.GetKeyPairInput) lightsail.GetKeyPairRequest

	GetKeyPairsRequest(*lightsail.GetKeyPairsInput) lightsail.GetKeyPairsRequest

	GetLoadBalancerRequest(*lightsail.GetLoadBalancerInput) lightsail.GetLoadBalancerRequest

	GetLoadBalancerMetricDataRequest(*lightsail.GetLoadBalancerMetricDataInput) lightsail.GetLoadBalancerMetricDataRequest

	GetLoadBalancerTlsCertificatesRequest(*lightsail.GetLoadBalancerTlsCertificatesInput) lightsail.GetLoadBalancerTlsCertificatesRequest

	GetLoadBalancersRequest(*lightsail.GetLoadBalancersInput) lightsail.GetLoadBalancersRequest

	GetOperationRequest(*lightsail.GetOperationInput) lightsail.GetOperationRequest

	GetOperationsRequest(*lightsail.GetOperationsInput) lightsail.GetOperationsRequest

	GetOperationsForResourceRequest(*lightsail.GetOperationsForResourceInput) lightsail.GetOperationsForResourceRequest

	GetRegionsRequest(*lightsail.GetRegionsInput) lightsail.GetRegionsRequest

	GetRelationalDatabaseRequest(*lightsail.GetRelationalDatabaseInput) lightsail.GetRelationalDatabaseRequest

	GetRelationalDatabaseBlueprintsRequest(*lightsail.GetRelationalDatabaseBlueprintsInput) lightsail.GetRelationalDatabaseBlueprintsRequest

	GetRelationalDatabaseBundlesRequest(*lightsail.GetRelationalDatabaseBundlesInput) lightsail.GetRelationalDatabaseBundlesRequest

	GetRelationalDatabaseEventsRequest(*lightsail.GetRelationalDatabaseEventsInput) lightsail.GetRelationalDatabaseEventsRequest

	GetRelationalDatabaseLogEventsRequest(*lightsail.GetRelationalDatabaseLogEventsInput) lightsail.GetRelationalDatabaseLogEventsRequest

	GetRelationalDatabaseLogStreamsRequest(*lightsail.GetRelationalDatabaseLogStreamsInput) lightsail.GetRelationalDatabaseLogStreamsRequest

	GetRelationalDatabaseMasterUserPasswordRequest(*lightsail.GetRelationalDatabaseMasterUserPasswordInput) lightsail.GetRelationalDatabaseMasterUserPasswordRequest

	GetRelationalDatabaseMetricDataRequest(*lightsail.GetRelationalDatabaseMetricDataInput) lightsail.GetRelationalDatabaseMetricDataRequest

	GetRelationalDatabaseParametersRequest(*lightsail.GetRelationalDatabaseParametersInput) lightsail.GetRelationalDatabaseParametersRequest

	GetRelationalDatabaseSnapshotRequest(*lightsail.GetRelationalDatabaseSnapshotInput) lightsail.GetRelationalDatabaseSnapshotRequest

	GetRelationalDatabaseSnapshotsRequest(*lightsail.GetRelationalDatabaseSnapshotsInput) lightsail.GetRelationalDatabaseSnapshotsRequest

	GetRelationalDatabasesRequest(*lightsail.GetRelationalDatabasesInput) lightsail.GetRelationalDatabasesRequest

	GetStaticIpRequest(*lightsail.GetStaticIpInput) lightsail.GetStaticIpRequest

	GetStaticIpsRequest(*lightsail.GetStaticIpsInput) lightsail.GetStaticIpsRequest

	ImportKeyPairRequest(*lightsail.ImportKeyPairInput) lightsail.ImportKeyPairRequest

	IsVpcPeeredRequest(*lightsail.IsVpcPeeredInput) lightsail.IsVpcPeeredRequest

	OpenInstancePublicPortsRequest(*lightsail.OpenInstancePublicPortsInput) lightsail.OpenInstancePublicPortsRequest

	PeerVpcRequest(*lightsail.PeerVpcInput) lightsail.PeerVpcRequest

	PutInstancePublicPortsRequest(*lightsail.PutInstancePublicPortsInput) lightsail.PutInstancePublicPortsRequest

	RebootInstanceRequest(*lightsail.RebootInstanceInput) lightsail.RebootInstanceRequest

	RebootRelationalDatabaseRequest(*lightsail.RebootRelationalDatabaseInput) lightsail.RebootRelationalDatabaseRequest

	ReleaseStaticIpRequest(*lightsail.ReleaseStaticIpInput) lightsail.ReleaseStaticIpRequest

	StartInstanceRequest(*lightsail.StartInstanceInput) lightsail.StartInstanceRequest

	StartRelationalDatabaseRequest(*lightsail.StartRelationalDatabaseInput) lightsail.StartRelationalDatabaseRequest

	StopInstanceRequest(*lightsail.StopInstanceInput) lightsail.StopInstanceRequest

	StopRelationalDatabaseRequest(*lightsail.StopRelationalDatabaseInput) lightsail.StopRelationalDatabaseRequest

	TagResourceRequest(*lightsail.TagResourceInput) lightsail.TagResourceRequest

	UnpeerVpcRequest(*lightsail.UnpeerVpcInput) lightsail.UnpeerVpcRequest

	UntagResourceRequest(*lightsail.UntagResourceInput) lightsail.UntagResourceRequest

	UpdateDomainEntryRequest(*lightsail.UpdateDomainEntryInput) lightsail.UpdateDomainEntryRequest

	UpdateLoadBalancerAttributeRequest(*lightsail.UpdateLoadBalancerAttributeInput) lightsail.UpdateLoadBalancerAttributeRequest

	UpdateRelationalDatabaseRequest(*lightsail.UpdateRelationalDatabaseInput) lightsail.UpdateRelationalDatabaseRequest

	UpdateRelationalDatabaseParametersRequest(*lightsail.UpdateRelationalDatabaseParametersInput) lightsail.UpdateRelationalDatabaseParametersRequest
}

var _ ClientAPI = (*lightsail.Client)(nil)
