// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mobile

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The details of the bundle.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/BundleDetails
type BundleDetails struct {
	_ struct{} `type:"structure"`

	// Developer desktop or mobile app or website platforms.
	AvailablePlatforms []Platform `locationName:"availablePlatforms" type:"list"`

	// Unique bundle identifier.
	BundleId *string `locationName:"bundleId" type:"string"`

	// Description of the download bundle.
	Description *string `locationName:"description" type:"string"`

	// Icon for the download bundle.
	IconUrl *string `locationName:"iconUrl" type:"string"`

	// Title of the download bundle.
	Title *string `locationName:"title" type:"string"`

	// Version of the download bundle.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s BundleDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BundleDetails) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AvailablePlatforms) > 0 {
		v := s.AvailablePlatforms

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "availablePlatforms", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.BundleId != nil {
		v := *s.BundleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bundleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IconUrl != nil {
		v := *s.IconUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iconUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Detailed information about an AWS Mobile Hub project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ProjectDetails
type ProjectDetails struct {
	_ struct{} `type:"structure"`

	// Website URL for this project in the AWS Mobile Hub console.
	ConsoleUrl *string `locationName:"consoleUrl" type:"string"`

	// Date the project was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"unix"`

	// Date of the last modification of the project.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"unix"`

	// Name of the project.
	Name *string `locationName:"name" type:"string"`

	// Unique project identifier.
	ProjectId *string `locationName:"projectId" type:"string"`

	// Default region to use for AWS resource creation in the AWS Mobile Hub project.
	Region *string `locationName:"region" type:"string"`

	// List of AWS resources associated with a project.
	Resources []Resource `locationName:"resources" type:"list"`

	// Synchronization state for a project.
	State ProjectState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s ProjectDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProjectDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConsoleUrl != nil {
		v := *s.ConsoleUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "consoleUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Resources) > 0 {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Summary information about an AWS Mobile Hub project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ProjectSummary
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// Name of the project.
	Name *string `locationName:"name" type:"string"`

	// Unique project identifier.
	ProjectId *string `locationName:"projectId" type:"string"`
}

// String returns the string representation
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProjectSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProjectId != nil {
		v := *s.ProjectId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "projectId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an instance of an AWS resource associated with a project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/Resource
type Resource struct {
	_ struct{} `type:"structure"`

	// AWS resource name which uniquely identifies the resource in AWS systems.
	Arn *string `locationName:"arn" type:"string"`

	// Key-value attribute pairs.
	Attributes map[string]string `locationName:"attributes" type:"map"`

	// Identifies which feature in AWS Mobile Hub is associated with this AWS resource.
	Feature *string `locationName:"feature" type:"string"`

	// Name of the AWS resource (e.g., for an Amazon S3 bucket this is the name
	// of the bucket).
	Name *string `locationName:"name" type:"string"`

	// Simplified name for type of AWS resource (e.g., bucket is an Amazon S3 bucket).
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Attributes) > 0 {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Feature != nil {
		v := *s.Feature

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "feature", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
