// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ApproveAssignmentRequest
type ApproveAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment. The assignment must correspond to a HIT created
	// by the Requester.
	//
	// AssignmentId is a required field
	AssignmentId *string `min:"1" type:"string" required:"true"`

	// A flag indicating that an assignment should be approved even if it was previously
	// rejected. Defaults to False.
	OverrideRejection *bool `type:"boolean"`

	// A message for the Worker, which the Worker can see in the Status section
	// of the web site.
	RequesterFeedback *string `type:"string"`
}

// String returns the string representation
func (s ApproveAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApproveAssignmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApproveAssignmentInput"}

	if s.AssignmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssignmentId"))
	}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssignmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ApproveAssignmentResponse
type ApproveAssignmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ApproveAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opApproveAssignment = "ApproveAssignment"

// ApproveAssignmentRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The ApproveAssignment operation approves the results of a completed assignment.
//
// Approving an assignment initiates two payments from the Requester's Amazon.com
// account
//
//    * The Worker who submitted the results is paid the reward specified in
//    the HIT.
//
//    * Amazon Mechanical Turk fees are debited.
//
// If the Requester's account does not have adequate funds for these payments,
// the call to ApproveAssignment returns an exception, and the approval is not
// processed. You can include an optional feedback message with the approval,
// which the Worker can see in the Status section of the web site.
//
// You can also call this operation for assignments that were previous rejected
// and approve them by explicitly overriding the previous rejection. This only
// works on rejected assignments that were submitted within the previous 30
// days and only if the assignment's related HIT has not been deleted.
//
//    // Example sending a request using ApproveAssignmentRequest.
//    req := client.ApproveAssignmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ApproveAssignment
func (c *Client) ApproveAssignmentRequest(input *ApproveAssignmentInput) ApproveAssignmentRequest {
	op := &aws.Operation{
		Name:       opApproveAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApproveAssignmentInput{}
	}

	req := c.newRequest(op, input, &ApproveAssignmentOutput{})
	return ApproveAssignmentRequest{Request: req, Input: input, Copy: c.ApproveAssignmentRequest}
}

// ApproveAssignmentRequest is the request type for the
// ApproveAssignment API operation.
type ApproveAssignmentRequest struct {
	*aws.Request
	Input *ApproveAssignmentInput
	Copy  func(*ApproveAssignmentInput) ApproveAssignmentRequest
}

// Send marshals and sends the ApproveAssignment API request.
func (r ApproveAssignmentRequest) Send(ctx context.Context) (*ApproveAssignmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ApproveAssignmentResponse{
		ApproveAssignmentOutput: r.Request.Data.(*ApproveAssignmentOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ApproveAssignmentResponse is the response type for the
// ApproveAssignment API operation.
type ApproveAssignmentResponse struct {
	*ApproveAssignmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ApproveAssignment request.
func (r *ApproveAssignmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
