// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package neptune

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroupMessage
type DeleteDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the database subnet group to delete.
	//
	// You can't delete the default subnet group.
	//
	// Constraints:
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSubnetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDBSubnetGroupInput"}

	if s.DBSubnetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroupOutput
type DeleteDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDBSubnetGroup = "DeleteDBSubnetGroup"

// DeleteDBSubnetGroupRequest returns a request value for making API operation for
// Amazon Neptune.
//
// Deletes a DB subnet group.
//
// The specified database subnet group must not be associated with any DB instances.
//
//    // Example sending a request using DeleteDBSubnetGroupRequest.
//    req := client.DeleteDBSubnetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DeleteDBSubnetGroup
func (c *Client) DeleteDBSubnetGroupRequest(input *DeleteDBSubnetGroupInput) DeleteDBSubnetGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSubnetGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteDBSubnetGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteDBSubnetGroupRequest{Request: req, Input: input, Copy: c.DeleteDBSubnetGroupRequest}
}

// DeleteDBSubnetGroupRequest is the request type for the
// DeleteDBSubnetGroup API operation.
type DeleteDBSubnetGroupRequest struct {
	*aws.Request
	Input *DeleteDBSubnetGroupInput
	Copy  func(*DeleteDBSubnetGroupInput) DeleteDBSubnetGroupRequest
}

// Send marshals and sends the DeleteDBSubnetGroup API request.
func (r DeleteDBSubnetGroupRequest) Send(ctx context.Context) (*DeleteDBSubnetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDBSubnetGroupResponse{
		DeleteDBSubnetGroupOutput: r.Request.Data.(*DeleteDBSubnetGroupOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDBSubnetGroupResponse is the response type for the
// DeleteDBSubnetGroup API operation.
type DeleteDBSubnetGroupResponse struct {
	*DeleteDBSubnetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDBSubnetGroup request.
func (r *DeleteDBSubnetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
