// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteUserProfileRequest
type DeleteUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN. This can also be a federated user's ARN.
	//
	// IamUserArn is a required field
	IamUserArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteUserProfileInput"}

	if s.IamUserArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamUserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteUserProfileOutput
type DeleteUserProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Deletes a user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DeleteUserProfileRequest.
//    req := client.DeleteUserProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteUserProfile
func (c *Client) DeleteUserProfileRequest(input *DeleteUserProfileInput) DeleteUserProfileRequest {
	op := &aws.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	req := c.newRequest(op, input, &DeleteUserProfileOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteUserProfileRequest{Request: req, Input: input, Copy: c.DeleteUserProfileRequest}
}

// DeleteUserProfileRequest is the request type for the
// DeleteUserProfile API operation.
type DeleteUserProfileRequest struct {
	*aws.Request
	Input *DeleteUserProfileInput
	Copy  func(*DeleteUserProfileInput) DeleteUserProfileRequest
}

// Send marshals and sends the DeleteUserProfile API request.
func (r DeleteUserProfileRequest) Send(ctx context.Context) (*DeleteUserProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteUserProfileResponse{
		DeleteUserProfileOutput: r.Request.Data.(*DeleteUserProfileOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteUserProfileResponse is the response type for the
// DeleteUserProfile API operation.
type DeleteUserProfileResponse struct {
	*DeleteUserProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteUserProfile request.
func (r *DeleteUserProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
