// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterEcsClusterRequest
type DeregisterEcsClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster's Amazon Resource Number (ARN).
	//
	// EcsClusterArn is a required field
	EcsClusterArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterEcsClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterEcsClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterEcsClusterInput"}

	if s.EcsClusterArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EcsClusterArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterEcsClusterOutput
type DeregisterEcsClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterEcsClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterEcsCluster = "DeregisterEcsCluster"

// DeregisterEcsClusterRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Deregisters a specified Amazon ECS cluster from a stack. For more information,
// see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html
// (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DeregisterEcsClusterRequest.
//    req := client.DeregisterEcsClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterEcsCluster
func (c *Client) DeregisterEcsClusterRequest(input *DeregisterEcsClusterInput) DeregisterEcsClusterRequest {
	op := &aws.Operation{
		Name:       opDeregisterEcsCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterEcsClusterInput{}
	}

	req := c.newRequest(op, input, &DeregisterEcsClusterOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeregisterEcsClusterRequest{Request: req, Input: input, Copy: c.DeregisterEcsClusterRequest}
}

// DeregisterEcsClusterRequest is the request type for the
// DeregisterEcsCluster API operation.
type DeregisterEcsClusterRequest struct {
	*aws.Request
	Input *DeregisterEcsClusterInput
	Copy  func(*DeregisterEcsClusterInput) DeregisterEcsClusterRequest
}

// Send marshals and sends the DeregisterEcsCluster API request.
func (r DeregisterEcsClusterRequest) Send(ctx context.Context) (*DeregisterEcsClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterEcsClusterResponse{
		DeregisterEcsClusterOutput: r.Request.Data.(*DeregisterEcsClusterOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterEcsClusterResponse is the response type for the
// DeregisterEcsCluster API operation.
type DeregisterEcsClusterResponse struct {
	*DeregisterEcsClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterEcsCluster request.
func (r *DeregisterEcsClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
