// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribePermissionsRequest
type DescribePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN. This can also be a federated user's ARN. For more information
	// about IAM ARNs, see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	IamUserArn *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribePermissions request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribePermissionsResult
type DescribePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Permission objects that describe the stack permissions.
	//
	//    * If the request object contains only a stack ID, the array contains a
	//    Permission object with permissions for each of the stack IAM ARNs.
	//
	//    * If the request object contains only an IAM ARN, the array contains a
	//    Permission object with permissions for each of the user's stack IDs.
	//
	//    * If the request contains a stack ID and an IAM ARN, the array contains
	//    a single Permission object with permissions for the specified stack and
	//    IAM ARN.
	Permissions []Permission `type:"list"`
}

// String returns the string representation
func (s DescribePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePermissions = "DescribePermissions"

// DescribePermissionsRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describes the permissions for a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DescribePermissionsRequest.
//    req := client.DescribePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribePermissions
func (c *Client) DescribePermissionsRequest(input *DescribePermissionsInput) DescribePermissionsRequest {
	op := &aws.Operation{
		Name:       opDescribePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePermissionsInput{}
	}

	req := c.newRequest(op, input, &DescribePermissionsOutput{})
	return DescribePermissionsRequest{Request: req, Input: input, Copy: c.DescribePermissionsRequest}
}

// DescribePermissionsRequest is the request type for the
// DescribePermissions API operation.
type DescribePermissionsRequest struct {
	*aws.Request
	Input *DescribePermissionsInput
	Copy  func(*DescribePermissionsInput) DescribePermissionsRequest
}

// Send marshals and sends the DescribePermissions API request.
func (r DescribePermissionsRequest) Send(ctx context.Context) (*DescribePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePermissionsResponse{
		DescribePermissionsOutput: r.Request.Data.(*DescribePermissionsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePermissionsResponse is the response type for the
// DescribePermissions API operation.
type DescribePermissionsResponse struct {
	*DescribePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePermissions request.
func (r *DescribePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
