// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopStackRequest
type StopStackInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopStackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopStackInput"}

	if s.StackId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopStackOutput
type StopStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopStackOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopStack = "StopStack"

// StopStackRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Stops a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using StopStackRequest.
//    req := client.StopStackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopStack
func (c *Client) StopStackRequest(input *StopStackInput) StopStackRequest {
	op := &aws.Operation{
		Name:       opStopStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStackInput{}
	}

	req := c.newRequest(op, input, &StopStackOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StopStackRequest{Request: req, Input: input, Copy: c.StopStackRequest}
}

// StopStackRequest is the request type for the
// StopStack API operation.
type StopStackRequest struct {
	*aws.Request
	Input *StopStackInput
	Copy  func(*StopStackInput) StopStackRequest
}

// Send marshals and sends the StopStack API request.
func (r StopStackRequest) Send(ctx context.Context) (*StopStackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopStackResponse{
		StopStackOutput: r.Request.Data.(*StopStackOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopStackResponse is the response type for the
// StopStack API operation.
type StopStackResponse struct {
	*StopStackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopStack request.
func (r *StopStackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
