// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnitRequest
type DescribeOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the organizational unit that you want details
	// about. You can get the ID from the ListOrganizationalUnitsForParent operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lower-case letters
	// or digits (the ID of the root that contains the OU) followed by a second
	// "-" dash and from 8 to 32 additional lower-case letters or digits.
	//
	// OrganizationalUnitId is a required field
	OrganizationalUnitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationalUnitInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeOrganizationalUnitInput"}

	if s.OrganizationalUnitId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationalUnitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnitResponse
type DescribeOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the specified OU.
	OrganizationalUnit *OrganizationalUnit `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeOrganizationalUnit = "DescribeOrganizationalUnit"

// DescribeOrganizationalUnitRequest returns a request value for making API operation for
// AWS Organizations.
//
// Retrieves information about an organizational unit (OU).
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using DescribeOrganizationalUnitRequest.
//    req := client.DescribeOrganizationalUnitRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnit
func (c *Client) DescribeOrganizationalUnitRequest(input *DescribeOrganizationalUnitInput) DescribeOrganizationalUnitRequest {
	op := &aws.Operation{
		Name:       opDescribeOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationalUnitInput{}
	}

	req := c.newRequest(op, input, &DescribeOrganizationalUnitOutput{})
	return DescribeOrganizationalUnitRequest{Request: req, Input: input, Copy: c.DescribeOrganizationalUnitRequest}
}

// DescribeOrganizationalUnitRequest is the request type for the
// DescribeOrganizationalUnit API operation.
type DescribeOrganizationalUnitRequest struct {
	*aws.Request
	Input *DescribeOrganizationalUnitInput
	Copy  func(*DescribeOrganizationalUnitInput) DescribeOrganizationalUnitRequest
}

// Send marshals and sends the DescribeOrganizationalUnit API request.
func (r DescribeOrganizationalUnitRequest) Send(ctx context.Context) (*DescribeOrganizationalUnitResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOrganizationalUnitResponse{
		DescribeOrganizationalUnitOutput: r.Request.Data.(*DescribeOrganizationalUnitOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeOrganizationalUnitResponse is the response type for the
// DescribeOrganizationalUnit API operation.
type DescribeOrganizationalUnitResponse struct {
	*DescribeOrganizationalUnitOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOrganizationalUnit request.
func (r *DescribeOrganizationalUnitResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
