// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStreamRequest
type PutEventStreamInput struct {
	_ struct{} `type:"structure" payload:"WriteEventStream"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Request to save an EventStream.
	//
	// WriteEventStream is a required field
	WriteEventStream *WriteEventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEventStreamInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.WriteEventStream == nil {
		invalidParams.Add(aws.NewErrParamRequired("WriteEventStream"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutEventStreamInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WriteEventStream != nil {
		v := s.WriteEventStream

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "WriteEventStream", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStreamResponse
type PutEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Model for an event publishing subscription export.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutEventStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EventStream != nil {
		v := s.EventStream

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "EventStream", v, metadata)
	}
	return nil
}

const opPutEventStream = "PutEventStream"

// PutEventStreamRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Use to create or update the event stream for an app.
//
//    // Example sending a request using PutEventStreamRequest.
//    req := client.PutEventStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream
func (c *Client) PutEventStreamRequest(input *PutEventStreamInput) PutEventStreamRequest {
	op := &aws.Operation{
		Name:       opPutEventStream,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &PutEventStreamInput{}
	}

	req := c.newRequest(op, input, &PutEventStreamOutput{})
	return PutEventStreamRequest{Request: req, Input: input, Copy: c.PutEventStreamRequest}
}

// PutEventStreamRequest is the request type for the
// PutEventStream API operation.
type PutEventStreamRequest struct {
	*aws.Request
	Input *PutEventStreamInput
	Copy  func(*PutEventStreamInput) PutEventStreamRequest
}

// Send marshals and sends the PutEventStream API request.
func (r PutEventStreamRequest) Send(ctx context.Context) (*PutEventStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEventStreamResponse{
		PutEventStreamOutput: r.Request.Data.(*PutEventStreamOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEventStreamResponse is the response type for the
// PutEventStream API operation.
type PutEventStreamResponse struct {
	*PutEventStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEventStream request.
func (r *PutEventStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
