// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpointemail

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An object that contains information about a blacklisting event that impacts
// one of the dedicated IP addresses that is associated with your account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/BlacklistEntry
type BlacklistEntry struct {
	_ struct{} `type:"structure"`

	// Additional information about the blacklisting event, as provided by the blacklist
	// maintainer.
	Description *string `type:"string"`

	// The time when the blacklisting event occurred, shown in Unix time format.
	ListingTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the blacklist that the IP address appears on.
	RblName *string `type:"string"`
}

// String returns the string representation
func (s BlacklistEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BlacklistEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ListingTime != nil {
		v := *s.ListingTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ListingTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.RblName != nil {
		v := *s.RblName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RblName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the body of the email message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/Body
type Body struct {
	_ struct{} `type:"structure"`

	// An object that represents the version of the message that is displayed in
	// email clients that support HTML. HTML messages can include formatted text,
	// hyperlinks, images, and more.
	Html *Content `type:"structure"`

	// An object that represents the version of the message that is displayed in
	// email clients that don't support HTML, or clients where the recipient has
	// disabled HTML rendering.
	Text *Content `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Body) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Body"}
	if s.Html != nil {
		if err := s.Html.Validate(); err != nil {
			invalidParams.AddNested("Html", err.(aws.ErrInvalidParams))
		}
	}
	if s.Text != nil {
		if err := s.Text.Validate(); err != nil {
			invalidParams.AddNested("Text", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Body) MarshalFields(e protocol.FieldEncoder) error {
	if s.Html != nil {
		v := s.Html

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Html", v, metadata)
	}
	if s.Text != nil {
		v := s.Text

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Text", v, metadata)
	}
	return nil
}

// An object that defines an Amazon CloudWatch destination for email events.
// You can use Amazon CloudWatch to monitor and gain insights on your email
// sending metrics.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CloudWatchDestination
type CloudWatchDestination struct {
	_ struct{} `type:"structure"`

	// An array of objects that define the dimensions to use when you send email
	// events to Amazon CloudWatch.
	//
	// DimensionConfigurations is a required field
	DimensionConfigurations []CloudWatchDimensionConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s CloudWatchDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchDestination"}

	if s.DimensionConfigurations == nil {
		invalidParams.Add(aws.NewErrParamRequired("DimensionConfigurations"))
	}
	if s.DimensionConfigurations != nil {
		for i, v := range s.DimensionConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudWatchDestination) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DimensionConfigurations) > 0 {
		v := s.DimensionConfigurations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DimensionConfigurations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object that defines the dimension configuration to use when you send Amazon
// Pinpoint email events to Amazon CloudWatch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/CloudWatchDimensionConfiguration
type CloudWatchDimensionConfiguration struct {
	_ struct{} `type:"structure"`

	// The default value of the dimension that is published to Amazon CloudWatch
	// if you don't provide the value of the dimension when you send an email. This
	// value has to meet the following criteria:
	//
	//    * It can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// DefaultDimensionValue is a required field
	DefaultDimensionValue *string `type:"string" required:"true"`

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name has to meet the following criteria:
	//
	//    * It can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// DimensionName is a required field
	DimensionName *string `type:"string" required:"true"`

	// The location where Amazon Pinpoint finds the value of a dimension to publish
	// to Amazon CloudWatch. If you want Amazon Pinpoint to use the message tags
	// that you specify using an X-SES-MESSAGE-TAGS header or a parameter to the
	// SendEmail/SendRawEmail API, choose messageTag. If you want Amazon Pinpoint
	// to use your own email headers, choose emailHeader. If you want Amazon Pinpoint
	// to use link tags, choose linkTags.
	//
	// DimensionValueSource is a required field
	DimensionValueSource DimensionValueSource `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CloudWatchDimensionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDimensionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchDimensionConfiguration"}

	if s.DefaultDimensionValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("DefaultDimensionValue"))
	}

	if s.DimensionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DimensionName"))
	}
	if len(s.DimensionValueSource) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DimensionValueSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudWatchDimensionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultDimensionValue != nil {
		v := *s.DefaultDimensionValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultDimensionValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DimensionName != nil {
		v := *s.DimensionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DimensionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DimensionValueSource) > 0 {
		v := s.DimensionValueSource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DimensionValueSource", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that represents the content of the email, and optionally a character
// set specification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/Content
type Content struct {
	_ struct{} `type:"structure"`

	// The character set for the content. Because of the constraints of the SMTP
	// protocol, Amazon Pinpoint uses 7-bit ASCII by default. If the text includes
	// characters outside of the ASCII range, you have to specify a character set.
	// For example, you could specify UTF-8, ISO-8859-1, or Shift_JIS.
	Charset *string `type:"string"`

	// The content of the message itself.
	//
	// Data is a required field
	Data *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Content"}

	if s.Data == nil {
		invalidParams.Add(aws.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Content) MarshalFields(e protocol.FieldEncoder) error {
	if s.Charset != nil {
		v := *s.Charset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Charset", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := *s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Data", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that contains information about the volume of email sent on each
// day of the analysis period.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DailyVolume
type DailyVolume struct {
	_ struct{} `type:"structure"`

	// An object that contains inbox placement metrics for a specified day in the
	// analysis period, broken out by the recipient's email provider.
	DomainIspPlacements []DomainIspPlacement `type:"list"`

	// The date that the DailyVolume metrics apply to, in Unix time.
	StartDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An object that contains inbox placement metrics for a specific day in the
	// analysis period.
	VolumeStatistics *VolumeStatistics `type:"structure"`
}

// String returns the string representation
func (s DailyVolume) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DailyVolume) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DomainIspPlacements) > 0 {
		v := s.DomainIspPlacements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DomainIspPlacements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.StartDate != nil {
		v := *s.StartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.VolumeStatistics != nil {
		v := s.VolumeStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VolumeStatistics", v, metadata)
	}
	return nil
}

// Contains information about a dedicated IP address that is associated with
// your Amazon Pinpoint account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DedicatedIp
type DedicatedIp struct {
	_ struct{} `type:"structure"`

	// An IP address that is reserved for use by your Amazon Pinpoint account.
	//
	// Ip is a required field
	Ip *string `type:"string" required:"true"`

	// The name of the dedicated IP pool that the IP address is associated with.
	PoolName *string `type:"string"`

	// Indicates how complete the dedicated IP warm-up process is. When this value
	// equals 1, the address has completed the warm-up process and is ready for
	// use.
	//
	// WarmupPercentage is a required field
	WarmupPercentage *int64 `type:"integer" required:"true"`

	// The warm-up status of a dedicated IP address. The status can have one of
	// the following values:
	//
	//    * IN_PROGRESS – The IP address isn't ready to use because the dedicated
	//    IP warm-up process is ongoing.
	//
	//    * DONE – The dedicated IP warm-up process is complete, and the IP address
	//    is ready to use.
	//
	// WarmupStatus is a required field
	WarmupStatus WarmupStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DedicatedIp) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DedicatedIp) MarshalFields(e protocol.FieldEncoder) error {
	if s.Ip != nil {
		v := *s.Ip

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Ip", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PoolName != nil {
		v := *s.PoolName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PoolName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WarmupPercentage != nil {
		v := *s.WarmupPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WarmupPercentage", protocol.Int64Value(v), metadata)
	}
	if len(s.WarmupStatus) > 0 {
		v := s.WarmupStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WarmupStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An object that contains metadata related to a predictive inbox placement
// test.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeliverabilityTestReport
type DeliverabilityTestReport struct {
	_ struct{} `type:"structure"`

	// The date and time when the predictive inbox placement test was created, in
	// Unix time format.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of the predictive inbox placement test. If the status is IN_PROGRESS,
	// then the predictive inbox placement test is currently running. Predictive
	// inbox placement tests are usually complete within 24 hours of creating the
	// test. If the status is COMPLETE, then the test is finished, and you can use
	// the GetDeliverabilityTestReport to view the results of the test.
	DeliverabilityTestStatus DeliverabilityTestStatus `type:"string" enum:"true"`

	// The sender address that you specified for the predictive inbox placement
	// test.
	FromEmailAddress *string `type:"string"`

	// A unique string that identifies the predictive inbox placement test.
	ReportId *string `type:"string"`

	// A name that helps you identify a predictive inbox placement test report.
	ReportName *string `type:"string"`

	// The subject line for an email that you submitted in a predictive inbox placement
	// test.
	Subject *string `type:"string"`
}

// String returns the string representation
func (s DeliverabilityTestReport) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeliverabilityTestReport) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreateDate != nil {
		v := *s.CreateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreateDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.DeliverabilityTestStatus) > 0 {
		v := s.DeliverabilityTestStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeliverabilityTestStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FromEmailAddress != nil {
		v := *s.FromEmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromEmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReportId != nil {
		v := *s.ReportId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReportId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReportName != nil {
		v := *s.ReportName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReportName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subject != nil {
		v := *s.Subject

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Subject", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Used to associate a configuration set with a dedicated IP pool.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DeliveryOptions
type DeliveryOptions struct {
	_ struct{} `type:"structure"`

	// The name of the dedicated IP pool that you want to associate with the configuration
	// set.
	SendingPoolName *string `type:"string"`
}

// String returns the string representation
func (s DeliveryOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeliveryOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.SendingPoolName != nil {
		v := *s.SendingPoolName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SendingPoolName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that describes the recipients for an email.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/Destination
type Destination struct {
	_ struct{} `type:"structure"`

	// An array that contains the email addresses of the "BCC" (blind carbon copy)
	// recipients for the email.
	BccAddresses []string `type:"list"`

	// An array that contains the email addresses of the "CC" (carbon copy) recipients
	// for the email.
	CcAddresses []string `type:"list"`

	// An array that contains the email addresses of the "To" recipients for the
	// email.
	ToAddresses []string `type:"list"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Destination) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.BccAddresses) > 0 {
		v := s.BccAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "BccAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.CcAddresses) > 0 {
		v := s.CcAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CcAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.ToAddresses) > 0 {
		v := s.ToAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ToAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object that contains information about the DKIM configuration for an email
// identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DkimAttributes
type DkimAttributes struct {
	_ struct{} `type:"structure"`

	// If the value is true, then the messages that Amazon Pinpoint sends from the
	// identity are DKIM-signed. If the value is false, then the messages that Amazon
	// Pinpoint sends from the identity aren't DKIM-signed.
	SigningEnabled *bool `type:"boolean"`

	// Describes whether or not Amazon Pinpoint has successfully located the DKIM
	// records in the DNS records for the domain. The status can be one of the following:
	//
	//    * PENDING – Amazon Pinpoint hasn't yet located the DKIM records in the
	//    DNS configuration for the domain, but will continue to attempt to locate
	//    them.
	//
	//    * SUCCESS – Amazon Pinpoint located the DKIM records in the DNS configuration
	//    for the domain and determined that they're correct. Amazon Pinpoint can
	//    now send DKIM-signed email from the identity.
	//
	//    * FAILED – Amazon Pinpoint was unable to locate the DKIM records in
	//    the DNS settings for the domain, and won't continue to search for them.
	//
	//    * TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon
	//    Pinpoint from determining the DKIM status for the domain.
	//
	//    * NOT_STARTED – Amazon Pinpoint hasn't yet started searching for the
	//    DKIM records in the DKIM records for the domain.
	Status DkimStatus `type:"string" enum:"true"`

	// A set of unique strings that you use to create a set of CNAME records that
	// you add to the DNS configuration for your domain. When Amazon Pinpoint detects
	// these records in the DNS configuration for your domain, the DKIM authentication
	// process is complete. Amazon Pinpoint usually detects these records within
	// about 72 hours of adding them to the DNS configuration for your domain.
	Tokens []string `type:"list"`
}

// String returns the string representation
func (s DkimAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DkimAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.SigningEnabled != nil {
		v := *s.SigningEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SigningEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tokens) > 0 {
		v := s.Tokens

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tokens", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object that contains the deliverability data for a specific campaign.
// This data is available for a campaign only if the campaign sent email by
// using a domain that the Deliverability dashboard is enabled for (PutDeliverabilityDashboardOption
// operation).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DomainDeliverabilityCampaign
type DomainDeliverabilityCampaign struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the campaign. Amazon Pinpoint automatically generates
	// and assigns this identifier to a campaign. This value is not the same as
	// the campaign identifier that Amazon Pinpoint assigns to campaigns that you
	// create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint
	// console.
	CampaignId *string `type:"string"`

	// The percentage of email messages that were deleted by recipients, without
	// being opened first. Due to technical limitations, this value only includes
	// recipients who opened the message by using an email client that supports
	// images.
	DeleteRate *float64 `type:"double"`

	// The major email providers who handled the email message.
	Esps []string `type:"list"`

	// The first time, in Unix time format, when the email message was delivered
	// to any recipient's inbox. This value can help you determine how long it took
	// for a campaign to deliver an email message.
	FirstSeenDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The verified email address that the email message was sent from.
	FromAddress *string `type:"string"`

	// The URL of an image that contains a snapshot of the email message that was
	// sent.
	ImageUrl *string `type:"string"`

	// The number of email messages that were delivered to recipients’ inboxes.
	InboxCount *int64 `type:"long"`

	// The last time, in Unix time format, when the email message was delivered
	// to any recipient's inbox. This value can help you determine how long it took
	// for a campaign to deliver an email message.
	LastSeenDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The projected number of recipients that the email message was sent to.
	ProjectedVolume *int64 `type:"long"`

	// The percentage of email messages that were opened and then deleted by recipients.
	// Due to technical limitations, this value only includes recipients who opened
	// the message by using an email client that supports images.
	ReadDeleteRate *float64 `type:"double"`

	// The percentage of email messages that were opened by recipients. Due to technical
	// limitations, this value only includes recipients who opened the message by
	// using an email client that supports images.
	ReadRate *float64 `type:"double"`

	// The IP addresses that were used to send the email message.
	SendingIps []string `type:"list"`

	// The number of email messages that were delivered to recipients' spam or junk
	// mail folders.
	SpamCount *int64 `type:"long"`

	// The subject line, or title, of the email message.
	Subject *string `type:"string"`
}

// String returns the string representation
func (s DomainDeliverabilityCampaign) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainDeliverabilityCampaign) MarshalFields(e protocol.FieldEncoder) error {
	if s.CampaignId != nil {
		v := *s.CampaignId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CampaignId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeleteRate != nil {
		v := *s.DeleteRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteRate", protocol.Float64Value(v), metadata)
	}
	if len(s.Esps) > 0 {
		v := s.Esps

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Esps", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.FirstSeenDateTime != nil {
		v := *s.FirstSeenDateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FirstSeenDateTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.FromAddress != nil {
		v := *s.FromAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InboxCount != nil {
		v := *s.InboxCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboxCount", protocol.Int64Value(v), metadata)
	}
	if s.LastSeenDateTime != nil {
		v := *s.LastSeenDateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastSeenDateTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ProjectedVolume != nil {
		v := *s.ProjectedVolume

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProjectedVolume", protocol.Int64Value(v), metadata)
	}
	if s.ReadDeleteRate != nil {
		v := *s.ReadDeleteRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReadDeleteRate", protocol.Float64Value(v), metadata)
	}
	if s.ReadRate != nil {
		v := *s.ReadRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReadRate", protocol.Float64Value(v), metadata)
	}
	if len(s.SendingIps) > 0 {
		v := s.SendingIps

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SendingIps", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SpamCount != nil {
		v := *s.SpamCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SpamCount", protocol.Int64Value(v), metadata)
	}
	if s.Subject != nil {
		v := *s.Subject

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Subject", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that contains information about the Deliverability dashboard subscription
// for a verified domain that you use to send email and currently has an active
// Deliverability dashboard subscription. If a Deliverability dashboard subscription
// is active for a domain, you gain access to reputation, inbox placement, and
// other metrics for the domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DomainDeliverabilityTrackingOption
type DomainDeliverabilityTrackingOption struct {
	_ struct{} `type:"structure"`

	// A verified domain that’s associated with your AWS account and currently
	// has an active Deliverability dashboard subscription.
	Domain *string `type:"string"`

	// An object that contains information about the inbox placement data settings
	// for the domain.
	InboxPlacementTrackingOption *InboxPlacementTrackingOption `type:"structure"`

	// The date, in Unix time format, when you enabled the Deliverability dashboard
	// for the domain.
	SubscriptionStartDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DomainDeliverabilityTrackingOption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainDeliverabilityTrackingOption) MarshalFields(e protocol.FieldEncoder) error {
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InboxPlacementTrackingOption != nil {
		v := s.InboxPlacementTrackingOption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InboxPlacementTrackingOption", v, metadata)
	}
	if s.SubscriptionStartDate != nil {
		v := *s.SubscriptionStartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubscriptionStartDate", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// An object that contains inbox placement data for email sent from one of your
// email domains to a specific email provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/DomainIspPlacement
type DomainIspPlacement struct {
	_ struct{} `type:"structure"`

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxPercentage *float64 `type:"double"`

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxRawCount *int64 `type:"long"`

	// The name of the email provider that the inbox placement data applies to.
	IspName *string `type:"string"`

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamPercentage *float64 `type:"double"`

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamRawCount *int64 `type:"long"`
}

// String returns the string representation
func (s DomainIspPlacement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainIspPlacement) MarshalFields(e protocol.FieldEncoder) error {
	if s.InboxPercentage != nil {
		v := *s.InboxPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboxPercentage", protocol.Float64Value(v), metadata)
	}
	if s.InboxRawCount != nil {
		v := *s.InboxRawCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboxRawCount", protocol.Int64Value(v), metadata)
	}
	if s.IspName != nil {
		v := *s.IspName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IspName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SpamPercentage != nil {
		v := *s.SpamPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SpamPercentage", protocol.Float64Value(v), metadata)
	}
	if s.SpamRawCount != nil {
		v := *s.SpamRawCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SpamRawCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An object that defines the entire content of the email, including the message
// headers and the body content. You can create a simple email message, in which
// you specify the subject and the text and HTML versions of the message body.
// You can also create raw messages, in which you specify a complete MIME-formatted
// message. Raw messages can include attachments and custom headers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/EmailContent
type EmailContent struct {
	_ struct{} `type:"structure"`

	// The raw email message. The message has to meet the following criteria:
	//
	//    * The message has to contain a header and a body, separated by one blank
	//    line.
	//
	//    * All of the required header fields must be present in the message.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * If you include attachments, they must be in a file format that Amazon
	//    Pinpoint supports.
	//
	//    * The entire message must be Base64 encoded.
	//
	//    * If any of the MIME parts in your message contain content that is outside
	//    of the 7-bit ASCII character range, you should encode that content to
	//    ensure that recipients' email clients render the message properly.
	//
	//    * The length of any single line of text in the message can't exceed 1,000
	//    characters. This restriction is defined in RFC 5321 (https://tools.ietf.org/html/rfc5321).
	Raw *RawMessage `type:"structure"`

	// The simple email message. The message consists of a subject and a message
	// body.
	Simple *Message `type:"structure"`
}

// String returns the string representation
func (s EmailContent) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailContent) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EmailContent"}
	if s.Raw != nil {
		if err := s.Raw.Validate(); err != nil {
			invalidParams.AddNested("Raw", err.(aws.ErrInvalidParams))
		}
	}
	if s.Simple != nil {
		if err := s.Simple.Validate(); err != nil {
			invalidParams.AddNested("Simple", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EmailContent) MarshalFields(e protocol.FieldEncoder) error {
	if s.Raw != nil {
		v := s.Raw

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Raw", v, metadata)
	}
	if s.Simple != nil {
		v := s.Simple

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Simple", v, metadata)
	}
	return nil
}

// In Amazon Pinpoint, events include message sends, deliveries, opens, clicks,
// bounces, and complaints. Event destinations are places that you can send
// information about these events to. For example, you can send event data to
// Amazon SNS to receive notifications when you receive bounces or complaints,
// or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for
// long-term storage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/EventDestination
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that defines an Amazon CloudWatch destination for email events.
	// You can use Amazon CloudWatch to monitor and gain insights on your email
	// sending metrics.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// If true, the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this EventDestinationDefinition.
	//
	// If false, the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled *bool `type:"boolean"`

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// The types of events that Amazon Pinpoint sends to the specified event destinations.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []EventType `type:"list" required:"true"`

	// A name that identifies the event destination.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An object that defines a Amazon Pinpoint destination for email events. You
	// can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects.
	// You can use these attributes to create segments for your campaigns.
	PinpointDestination *PinpointDestination `type:"structure"`

	// An object that defines an Amazon SNS destination for email events. You can
	// use Amazon SNS to send notification when certain email events occur.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudWatchDestination != nil {
		v := s.CloudWatchDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CloudWatchDestination", v, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.KinesisFirehoseDestination != nil {
		v := s.KinesisFirehoseDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "KinesisFirehoseDestination", v, metadata)
	}
	if len(s.MatchingEventTypes) > 0 {
		v := s.MatchingEventTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MatchingEventTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PinpointDestination != nil {
		v := s.PinpointDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PinpointDestination", v, metadata)
	}
	if s.SnsDestination != nil {
		v := s.SnsDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SnsDestination", v, metadata)
	}
	return nil
}

// An object that defines the event destination. Specifically, it defines which
// services receive events from emails sent using the configuration set that
// the event destination is associated with. Also defines the types of events
// that are sent to the event destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/EventDestinationDefinition
type EventDestinationDefinition struct {
	_ struct{} `type:"structure"`

	// An object that defines an Amazon CloudWatch destination for email events.
	// You can use Amazon CloudWatch to monitor and gain insights on your email
	// sending metrics.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// If true, the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this EventDestinationDefinition.
	//
	// If false, the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled *bool `type:"boolean"`

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array that specifies which events Amazon Pinpoint should send to the destinations
	// in this EventDestinationDefinition.
	MatchingEventTypes []EventType `type:"list"`

	// An object that defines a Amazon Pinpoint destination for email events. You
	// can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects.
	// You can use these attributes to create segments for your campaigns.
	PinpointDestination *PinpointDestination `type:"structure"`

	// An object that defines an Amazon SNS destination for email events. You can
	// use Amazon SNS to send notification when certain email events occur.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation
func (s EventDestinationDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDestinationDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EventDestinationDefinition"}
	if s.CloudWatchDestination != nil {
		if err := s.CloudWatchDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchDestination", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(aws.ErrInvalidParams))
		}
	}
	if s.SnsDestination != nil {
		if err := s.SnsDestination.Validate(); err != nil {
			invalidParams.AddNested("SnsDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventDestinationDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudWatchDestination != nil {
		v := s.CloudWatchDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CloudWatchDestination", v, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.KinesisFirehoseDestination != nil {
		v := s.KinesisFirehoseDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "KinesisFirehoseDestination", v, metadata)
	}
	if len(s.MatchingEventTypes) > 0 {
		v := s.MatchingEventTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MatchingEventTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.PinpointDestination != nil {
		v := s.PinpointDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PinpointDestination", v, metadata)
	}
	if s.SnsDestination != nil {
		v := s.SnsDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SnsDestination", v, metadata)
	}
	return nil
}

// Information about an email identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/IdentityInfo
type IdentityInfo struct {
	_ struct{} `type:"structure"`

	// The address or domain of the identity.
	IdentityName *string `type:"string"`

	// The email identity type. The identity type can be one of the following:
	//
	//    * EMAIL_ADDRESS – The identity is an email address.
	//
	//    * DOMAIN – The identity is a domain.
	//
	//    * MANAGED_DOMAIN – The identity is a domain that is managed by AWS.
	IdentityType IdentityType `type:"string" enum:"true"`

	// Indicates whether or not you can send email from the identity.
	//
	// In Amazon Pinpoint, an identity is an email address or domain that you send
	// email from. Before you can send email from an identity, you have to demostrate
	// that you own the identity, and that you authorize Amazon Pinpoint to send
	// email from that identity.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s IdentityInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IdentityInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.IdentityName != nil {
		v := *s.IdentityName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IdentityType) > 0 {
		v := s.IdentityType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SendingEnabled != nil {
		v := *s.SendingEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SendingEnabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// An object that contains information about the inbox placement data settings
// for a verified domain that’s associated with your AWS account. This data
// is available only if you enabled the Deliverability dashboard for the domain
// (PutDeliverabilityDashboardOption operation).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/InboxPlacementTrackingOption
type InboxPlacementTrackingOption struct {
	_ struct{} `type:"structure"`

	// Specifies whether inbox placement data is being tracked for the domain.
	Global *bool `type:"boolean"`

	// An array of strings, one for each major email provider that the inbox placement
	// data applies to.
	TrackedIsps []string `type:"list"`
}

// String returns the string representation
func (s InboxPlacementTrackingOption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InboxPlacementTrackingOption) MarshalFields(e protocol.FieldEncoder) error {
	if s.Global != nil {
		v := *s.Global

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Global", protocol.BoolValue(v), metadata)
	}
	if len(s.TrackedIsps) > 0 {
		v := s.TrackedIsps

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TrackedIsps", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object that describes how email sent during the predictive inbox placement
// test was handled by a certain email provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/IspPlacement
type IspPlacement struct {
	_ struct{} `type:"structure"`

	// The name of the email provider that the inbox placement data applies to.
	IspName *string `type:"string"`

	// An object that contains inbox placement metrics for a specific email provider.
	PlacementStatistics *PlacementStatistics `type:"structure"`
}

// String returns the string representation
func (s IspPlacement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IspPlacement) MarshalFields(e protocol.FieldEncoder) error {
	if s.IspName != nil {
		v := *s.IspName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IspName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PlacementStatistics != nil {
		v := s.PlacementStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PlacementStatistics", v, metadata)
	}
	return nil
}

// An object that defines an Amazon Kinesis Data Firehose destination for email
// events. You can use Amazon Kinesis Data Firehose to stream data to other
// services, such as Amazon S3 and Amazon Redshift.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/KinesisFirehoseDestination
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream
	// that Amazon Pinpoint sends email events to.
	//
	// DeliveryStreamArn is a required field
	DeliveryStreamArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that Amazon Pinpoint uses
	// when sending email events to the Amazon Kinesis Data Firehose stream.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseDestination"}

	if s.DeliveryStreamArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamArn"))
	}

	if s.IamRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KinesisFirehoseDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeliveryStreamArn != nil {
		v := *s.DeliveryStreamArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeliveryStreamArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A list of attributes that are associated with a MAIL FROM domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/MailFromAttributes
type MailFromAttributes struct {
	_ struct{} `type:"structure"`

	// The action that Amazon Pinpoint to takes if it can't read the required MX
	// record for a custom MAIL FROM domain. When you set this value to UseDefaultValue,
	// Amazon Pinpoint uses amazonses.com as the MAIL FROM domain. When you set
	// this value to RejectMessage, Amazon Pinpoint returns a MailFromDomainNotVerified
	// error, and doesn't attempt to deliver the email.
	//
	// These behaviors are taken when the custom MAIL FROM domain configuration
	// is in the Pending, Failed, and TemporaryFailure states.
	//
	// BehaviorOnMxFailure is a required field
	BehaviorOnMxFailure BehaviorOnMxFailure `type:"string" required:"true" enum:"true"`

	// The name of a domain that an email identity uses as a custom MAIL FROM domain.
	//
	// MailFromDomain is a required field
	MailFromDomain *string `type:"string" required:"true"`

	// The status of the MAIL FROM domain. This status can have the following values:
	//
	//    * PENDING – Amazon Pinpoint hasn't started searching for the MX record
	//    yet.
	//
	//    * SUCCESS – Amazon Pinpoint detected the required MX record for the
	//    MAIL FROM domain.
	//
	//    * FAILED – Amazon Pinpoint can't find the required MX record, or the
	//    record no longer exists.
	//
	//    * TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon
	//    Pinpoint from determining the status of the MAIL FROM domain.
	//
	// MailFromDomainStatus is a required field
	MailFromDomainStatus MailFromDomainStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s MailFromAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MailFromAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.BehaviorOnMxFailure) > 0 {
		v := s.BehaviorOnMxFailure

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BehaviorOnMxFailure", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MailFromDomain != nil {
		v := *s.MailFromDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MailFromDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.MailFromDomainStatus) > 0 {
		v := s.MailFromDomainStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MailFromDomainStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Represents the email message that you're sending. The Message object consists
// of a subject line and a message body.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/Message
type Message struct {
	_ struct{} `type:"structure"`

	// The body of the message. You can specify an HTML version of the message,
	// a text-only version of the message, or both.
	//
	// Body is a required field
	Body *Body `type:"structure" required:"true"`

	// The subject line of the email. The subject line can only contain 7-bit ASCII
	// characters. However, you can specify non-ASCII characters in the subject
	// line by using encoded-word syntax, as described in RFC 2047 (https://tools.ietf.org/html/rfc2047).
	//
	// Subject is a required field
	Subject *Content `type:"structure" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Message"}

	if s.Body == nil {
		invalidParams.Add(aws.NewErrParamRequired("Body"))
	}

	if s.Subject == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subject"))
	}
	if s.Body != nil {
		if err := s.Body.Validate(); err != nil {
			invalidParams.AddNested("Body", err.(aws.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Message) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := s.Body

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Body", v, metadata)
	}
	if s.Subject != nil {
		v := s.Subject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Subject", v, metadata)
	}
	return nil
}

// Contains the name and value of a tag that you apply to an email. You can
// use message tags when you publish email sending events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/MessageTag
type MessageTag struct {
	_ struct{} `type:"structure"`

	// The name of the message tag. The message tag name has to meet the following
	// criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the message tag. The message tag value has to meet the following
	// criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MessageTag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MessageTag"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MessageTag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that contains information about email that was sent from the selected
// domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/OverallVolume
type OverallVolume struct {
	_ struct{} `type:"structure"`

	// An object that contains inbox and junk mail placement metrics for individual
	// email providers.
	DomainIspPlacements []DomainIspPlacement `type:"list"`

	// The percentage of emails that were sent from the domain that were read by
	// their recipients.
	ReadRatePercent *float64 `type:"double"`

	// An object that contains information about the numbers of messages that arrived
	// in recipients' inboxes and junk mail folders.
	VolumeStatistics *VolumeStatistics `type:"structure"`
}

// String returns the string representation
func (s OverallVolume) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OverallVolume) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.DomainIspPlacements) > 0 {
		v := s.DomainIspPlacements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DomainIspPlacements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ReadRatePercent != nil {
		v := *s.ReadRatePercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReadRatePercent", protocol.Float64Value(v), metadata)
	}
	if s.VolumeStatistics != nil {
		v := s.VolumeStatistics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VolumeStatistics", v, metadata)
	}
	return nil
}

// An object that defines a Amazon Pinpoint destination for email events. You
// can use Amazon Pinpoint events to create attributes in Amazon Pinpoint projects.
// You can use these attributes to create segments for your campaigns.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PinpointDestination
type PinpointDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want
	// to send email events to.
	ApplicationArn *string `type:"string"`
}

// String returns the string representation
func (s PinpointDestination) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PinpointDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationArn != nil {
		v := *s.ApplicationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that contains inbox placement data for an email provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PlacementStatistics
type PlacementStatistics struct {
	_ struct{} `type:"structure"`

	// The percentage of emails that were authenticated by using DomainKeys Identified
	// Mail (DKIM) during the predictive inbox placement test.
	DkimPercentage *float64 `type:"double"`

	// The percentage of emails that arrived in recipients' inboxes during the predictive
	// inbox placement test.
	InboxPercentage *float64 `type:"double"`

	// The percentage of emails that didn't arrive in recipients' inboxes at all
	// during the predictive inbox placement test.
	MissingPercentage *float64 `type:"double"`

	// The percentage of emails that arrived in recipients' spam or junk mail folders
	// during the predictive inbox placement test.
	SpamPercentage *float64 `type:"double"`

	// The percentage of emails that were authenticated by using Sender Policy Framework
	// (SPF) during the predictive inbox placement test.
	SpfPercentage *float64 `type:"double"`
}

// String returns the string representation
func (s PlacementStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PlacementStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.DkimPercentage != nil {
		v := *s.DkimPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DkimPercentage", protocol.Float64Value(v), metadata)
	}
	if s.InboxPercentage != nil {
		v := *s.InboxPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboxPercentage", protocol.Float64Value(v), metadata)
	}
	if s.MissingPercentage != nil {
		v := *s.MissingPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MissingPercentage", protocol.Float64Value(v), metadata)
	}
	if s.SpamPercentage != nil {
		v := *s.SpamPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SpamPercentage", protocol.Float64Value(v), metadata)
	}
	if s.SpfPercentage != nil {
		v := *s.SpfPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SpfPercentage", protocol.Float64Value(v), metadata)
	}
	return nil
}

// The raw email message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/RawMessage
type RawMessage struct {
	_ struct{} `type:"structure"`

	// The raw email message. The message has to meet the following criteria:
	//
	//    * The message has to contain a header and a body, separated by one blank
	//    line.
	//
	//    * All of the required header fields must be present in the message.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * Attachments must be in a file format that Amazon Pinpoint supports.
	//
	//    * The entire message must be Base64 encoded.
	//
	//    * If any of the MIME parts in your message contain content that is outside
	//    of the 7-bit ASCII character range, you should encode that content to
	//    ensure that recipients' email clients render the message properly.
	//
	//    * The length of any single line of text in the message can't exceed 1,000
	//    characters. This restriction is defined in RFC 5321 (https://tools.ietf.org/html/rfc5321).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RawMessage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RawMessage"}

	if s.Data == nil {
		invalidParams.Add(aws.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RawMessage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Data != nil {
		v := s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Data", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// Enable or disable collection of reputation metrics for emails that you send
// using this configuration set in the current AWS Region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ReputationOptions
type ReputationOptions struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) when the reputation metrics were last given
	// a fresh start. When your account is given a fresh start, your reputation
	// metrics are calculated starting from the date of the fresh start.
	LastFreshStart *time.Time `type:"timestamp" timestampFormat:"unix"`

	// If true, tracking of reputation metrics is enabled for the configuration
	// set. If false, tracking of reputation metrics is disabled for the configuration
	// set.
	ReputationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ReputationOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReputationOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.LastFreshStart != nil {
		v := *s.LastFreshStart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastFreshStart", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ReputationMetricsEnabled != nil {
		v := *s.ReputationMetricsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReputationMetricsEnabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// An object that contains information about the per-day and per-second sending
// limits for your Amazon Pinpoint account in the current AWS Region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/SendQuota
type SendQuota struct {
	_ struct{} `type:"structure"`

	// The maximum number of emails that you can send in the current AWS Region
	// over a 24-hour period. This value is also called your sending quota.
	Max24HourSend *float64 `type:"double"`

	// The maximum number of emails that you can send per second in the current
	// AWS Region. This value is also called your maximum sending rate or your maximum
	// TPS (transactions per second) rate.
	MaxSendRate *float64 `type:"double"`

	// The number of emails sent from your Amazon Pinpoint account in the current
	// AWS Region over the past 24 hours.
	SentLast24Hours *float64 `type:"double"`
}

// String returns the string representation
func (s SendQuota) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendQuota) MarshalFields(e protocol.FieldEncoder) error {
	if s.Max24HourSend != nil {
		v := *s.Max24HourSend

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Max24HourSend", protocol.Float64Value(v), metadata)
	}
	if s.MaxSendRate != nil {
		v := *s.MaxSendRate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxSendRate", protocol.Float64Value(v), metadata)
	}
	if s.SentLast24Hours != nil {
		v := *s.SentLast24Hours

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SentLast24Hours", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Used to enable or disable email sending for messages that use this configuration
// set in the current AWS Region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/SendingOptions
type SendingOptions struct {
	_ struct{} `type:"structure"`

	// If true, email sending is enabled for the configuration set. If false, email
	// sending is disabled for the configuration set.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s SendingOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendingOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.SendingEnabled != nil {
		v := *s.SendingEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SendingEnabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// An object that defines an Amazon SNS destination for email events. You can
// use Amazon SNS to send notification when certain email events occur.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/SnsDestination
type SnsDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish
	// email events to. For more information about Amazon SNS topics, see the Amazon
	// SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SnsDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SnsDestination"}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SnsDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.TopicArn != nil {
		v := *s.TopicArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TopicArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that defines the tags that are associated with a resource. A tag
// is a label that you optionally define and associate with a resource in Amazon
// Pinpoint. Tags can help you categorize and manage resources in different
// ways, such as by purpose, owner, environment, or other criteria. A resource
// can have as many as 50 tags.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for a more specific tag value. A tag value acts as a descriptor within a
// tag key. A tag key can contain as many as 128 characters. A tag value can
// contain as many as 256 characters. The characters can be Unicode letters,
// digits, white space, or one of the following symbols: _ . : / = + -. The
// following additional restrictions apply to tags:
//
//    * Tag keys and values are case sensitive.
//
//    * For each associated resource, each tag key must be unique and it can
//    have only one value.
//
//    * The aws: prefix is reserved for use by AWS; you can’t use it in any
//    tag keys or values that you define. In addition, you can't edit or remove
//    tag keys or values that use this prefix. Tags that use this prefix don’t
//    count against the limit of 50 tags per resource.
//
//    * You can associate tags with public or shared resources, but the tags
//    are available only for your AWS account, not any other accounts that share
//    the resource. In addition, the tags are available only for resources that
//    are located in the specified AWS Region for your AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that defines a tag. The maximum length of a
	// tag key is 128 characters. The minimum length is 1 character.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The optional part of a key-value pair that defines a tag. The maximum length
	// of a tag value is 256 characters. The minimum length is 0 characters. If
	// you don’t want a resource to have a specific tag value, don’t specify
	// a value for this parameter. Amazon Pinpoint will set the value to an empty
	// string.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that defines the tracking options for a configuration set. When
// you use Amazon Pinpoint to send an email, it contains an invisible image
// that's used to track when recipients open your email. If your email contains
// links, those links are changed slightly in order to track when recipients
// click them.
//
// These images and links include references to a domain operated by AWS. You
// can optionally configure Amazon Pinpoint to use a domain that you operate
// for these images and links.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/TrackingOptions
type TrackingOptions struct {
	_ struct{} `type:"structure"`

	// The domain that you want to use for tracking open and click events.
	//
	// CustomRedirectDomain is a required field
	CustomRedirectDomain *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TrackingOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrackingOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TrackingOptions"}

	if s.CustomRedirectDomain == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomRedirectDomain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TrackingOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomRedirectDomain != nil {
		v := *s.CustomRedirectDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CustomRedirectDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object that contains information about the amount of email that was delivered
// to recipients.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/VolumeStatistics
type VolumeStatistics struct {
	_ struct{} `type:"structure"`

	// The total number of emails that arrived in recipients' inboxes.
	InboxRawCount *int64 `type:"long"`

	// An estimate of the percentage of emails sent from the current domain that
	// will arrive in recipients' inboxes.
	ProjectedInbox *int64 `type:"long"`

	// An estimate of the percentage of emails sent from the current domain that
	// will arrive in recipients' spam or junk mail folders.
	ProjectedSpam *int64 `type:"long"`

	// The total number of emails that arrived in recipients' spam or junk mail
	// folders.
	SpamRawCount *int64 `type:"long"`
}

// String returns the string representation
func (s VolumeStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VolumeStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.InboxRawCount != nil {
		v := *s.InboxRawCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboxRawCount", protocol.Int64Value(v), metadata)
	}
	if s.ProjectedInbox != nil {
		v := *s.ProjectedInbox

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProjectedInbox", protocol.Int64Value(v), metadata)
	}
	if s.ProjectedSpam != nil {
		v := *s.ProjectedSpam

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProjectedSpam", protocol.Int64Value(v), metadata)
	}
	if s.SpamRawCount != nil {
		v := *s.SpamRawCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SpamRawCount", protocol.Int64Value(v), metadata)
	}
	return nil
}
