// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalClusterMessage
type DeleteGlobalClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier of the global database cluster being deleted.
	//
	// GlobalClusterIdentifier is a required field
	GlobalClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGlobalClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlobalClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteGlobalClusterInput"}

	if s.GlobalClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalClusterResult
type DeleteGlobalClusterOutput struct {
	_ struct{} `type:"structure"`

	// A data type representing an Aurora global database.
	GlobalCluster *GlobalCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteGlobalClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteGlobalCluster = "DeleteGlobalCluster"

// DeleteGlobalClusterRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Deletes a global database cluster. The primary and secondary clusters must
// already be detached or destroyed first.
//
// This action only applies to Aurora DB clusters.
//
//    // Example sending a request using DeleteGlobalClusterRequest.
//    req := client.DeleteGlobalClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster
func (c *Client) DeleteGlobalClusterRequest(input *DeleteGlobalClusterInput) DeleteGlobalClusterRequest {
	op := &aws.Operation{
		Name:       opDeleteGlobalCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGlobalClusterInput{}
	}

	req := c.newRequest(op, input, &DeleteGlobalClusterOutput{})
	return DeleteGlobalClusterRequest{Request: req, Input: input, Copy: c.DeleteGlobalClusterRequest}
}

// DeleteGlobalClusterRequest is the request type for the
// DeleteGlobalCluster API operation.
type DeleteGlobalClusterRequest struct {
	*aws.Request
	Input *DeleteGlobalClusterInput
	Copy  func(*DeleteGlobalClusterInput) DeleteGlobalClusterRequest
}

// Send marshals and sends the DeleteGlobalCluster API request.
func (r DeleteGlobalClusterRequest) Send(ctx context.Context) (*DeleteGlobalClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteGlobalClusterResponse{
		DeleteGlobalClusterOutput: r.Request.Data.(*DeleteGlobalClusterOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteGlobalClusterResponse is the response type for the
// DeleteGlobalCluster API operation.
type DeleteGlobalClusterResponse struct {
	*DeleteGlobalClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteGlobalCluster request.
func (r *DeleteGlobalClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
