// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to get information about a specified reusable delegation set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetRequest
type GetReusableDelegationSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the reusable delegation set that you want to get a list of name
	// servers for.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReusableDelegationSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetReusableDelegationSetInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetReusableDelegationSetInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains the response to the GetReusableDelegationSet
// request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSetResponse
type GetReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the reusable delegation set.
	//
	// DelegationSet is a required field
	DelegationSet *DelegationSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetReusableDelegationSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DelegationSet != nil {
		v := s.DelegationSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DelegationSet", v, metadata)
	}
	return nil
}

const opGetReusableDelegationSet = "GetReusableDelegationSet"

// GetReusableDelegationSetRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Retrieves information about a specified reusable delegation set, including
// the four name servers that are assigned to the delegation set.
//
//    // Example sending a request using GetReusableDelegationSetRequest.
//    req := client.GetReusableDelegationSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet
func (c *Client) GetReusableDelegationSetRequest(input *GetReusableDelegationSetInput) GetReusableDelegationSetRequest {
	op := &aws.Operation{
		Name:       opGetReusableDelegationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &GetReusableDelegationSetInput{}
	}

	req := c.newRequest(op, input, &GetReusableDelegationSetOutput{})
	return GetReusableDelegationSetRequest{Request: req, Input: input, Copy: c.GetReusableDelegationSetRequest}
}

// GetReusableDelegationSetRequest is the request type for the
// GetReusableDelegationSet API operation.
type GetReusableDelegationSetRequest struct {
	*aws.Request
	Input *GetReusableDelegationSetInput
	Copy  func(*GetReusableDelegationSetInput) GetReusableDelegationSetRequest
}

// Send marshals and sends the GetReusableDelegationSet API request.
func (r GetReusableDelegationSetRequest) Send(ctx context.Context) (*GetReusableDelegationSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetReusableDelegationSetResponse{
		GetReusableDelegationSetOutput: r.Request.Data.(*GetReusableDelegationSetOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetReusableDelegationSetResponse is the response type for the
// GetReusableDelegationSet API operation.
type GetReusableDelegationSetResponse struct {
	*GetReusableDelegationSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetReusableDelegationSet request.
func (r *GetReusableDelegationSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
